/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.nodes.ContainerNode;
import com.intellij.spring.data.commons.util.nodes.OrSetNode;
import com.intellij.spring.data.commons.util.nodes.OrderByNode;
import com.intellij.spring.data.commons.util.nodes.QueryNode;
import com.intellij.spring.data.commons.util.nodes.SimpleLeaf;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RootNode
extends ContainerNode {
    private static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
    private final Set<QueryNode> nodes;
    private boolean alwaysIgnoreCase;

    public RootNode(@NotNull String expression, String methodType) {
        if (expression == null) {
            RootNode.$$$reportNull$$$0(0);
        }
        super(expression);
        this.nodes = new LinkedHashSet<QueryNode>();
        this.alwaysIgnoreCase = false;
        if (!StringUtil.isEmptyOrSpaces((String)methodType)) {
            this.nodes.add(new SimpleLeaf(methodType));
        }
        List orderByParts = StringUtil.split((String)this.detectAndSetAllIgnoreCase(expression), (String)"OrderBy", (boolean)true, (boolean)false);
        for (int i = 0; i < orderByParts.size(); ++i) {
            String orderBy = (String)orderByParts.get(i);
            if (i == 0) {
                this.nodes.add(new OrSetNode(orderBy));
            } else {
                this.nodes.add(new OrderByNode(orderBy));
            }
            if (i == orderByParts.size() - 1) continue;
            this.nodes.add(new SimpleLeaf("OrderBy"));
        }
    }

    @Override
    @NotNull
    public Set<? extends QueryNode> getChildren() {
        Set<QueryNode> set = this.nodes;
        if (set == null) {
            RootNode.$$$reportNull$$$0(1);
        }
        return set;
    }

    private String detectAndSetAllIgnoreCase(String expression) {
        Matcher matcher = ALL_IGNORE_CASE.matcher(expression);
        if (matcher.find()) {
            this.alwaysIgnoreCase = true;
            expression = expression.substring(0, matcher.start()) + expression.substring(matcher.end(), expression.length());
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/util/nodes/RootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/util/nodes/RootNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

