/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class JavaFlexibleTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    private static final String id = "kotlin.jvm.PlatformType";
    public static final JavaFlexibleTypeDeserializer INSTANCE;

    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)flexibleId, (String)"flexibleId");
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        if (Intrinsics.areEqual((Object)flexibleId, (Object)id) ^ true) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Error java flexible type with id: " + flexibleId + ". (" + lowerBound + ".." + upperBound + ')');
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026owerBound..$upperBound)\")");
            return simpleType2;
        }
        if (proto.hasExtension(JvmProtoBuf.isRaw)) {
            return new RawTypeImpl(lowerBound, upperBound);
        }
        return KotlinTypeFactory.flexibleType(lowerBound, upperBound);
    }

    private JavaFlexibleTypeDeserializer() {
    }

    static {
        JavaFlexibleTypeDeserializer javaFlexibleTypeDeserializer;
        INSTANCE = javaFlexibleTypeDeserializer = new JavaFlexibleTypeDeserializer();
        id = id;
    }
}

