/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiTreeDebugBuilder;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.jetbrains.annotations.NotNull;

public class XPathElementImpl
extends ASTWrapperPsiElement
implements XPathElement {
    public XPathElementImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1) + ": " + this.getText();
    }

    public PsiElement addBefore(@NotNull PsiElement psiElement, PsiElement anchor) throws IncorrectOperationException {
        if (psiElement == null) {
            XPathElementImpl.$$$reportNull$$$0(0);
        }
        ASTNode node = this.getNode();
        ASTNode child = psiElement.getNode();
        assert (child != null);
        node.addChild(child, anchor.getNode());
        return node.getPsi();
    }

    public PsiElement addAfter(@NotNull PsiElement psiElement, PsiElement anchor) throws IncorrectOperationException {
        if (psiElement == null) {
            XPathElementImpl.$$$reportNull$$$0(1);
        }
        ASTNode astNode = anchor.getNode();
        assert (astNode != null);
        ASTNode next = astNode.getTreeNext();
        ASTNode node = this.getNode();
        ASTNode newNode = psiElement.getNode();
        assert (newNode != null);
        if (next != null) {
            node.addChild(newNode, next);
        } else {
            node.addChild(newNode);
        }
        return node.getPsi();
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            XPathElementImpl.$$$reportNull$$$0(2);
        }
        ASTNode child = psiElement.getNode();
        assert (child != null);
        this.getNode().addChild(child);
        return this.getNode().getPsi();
    }

    public void delete() throws IncorrectOperationException {
        ASTNode node = this.getNode();
        ASTNode parent = node.getTreeParent();
        ASTNode next = node.getTreeNext();
        parent.removeChild(node);
        if (XPath2ElementTypes.EXPRESSIONS.contains(node.getElementType()) && parent.getElementType() == XPathElementTypes.FUNCTION_CALL && next != null && next.getElementType() == XPathTokenTypes.COMMA) {
            parent.removeChild(next);
        }
    }

    public PsiElement replace(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            XPathElementImpl.$$$reportNull$$$0(3);
        }
        ASTNode newNode = psiElement.getNode();
        ASTNode myNode = this.getNode();
        assert (newNode != null);
        myNode.getTreeParent().replaceChild(myNode, newNode);
        return newNode.getPsi();
    }

    @Override
    @NotNull
    public final ASTNode getNode() {
        ASTNode aSTNode = super.getNode();
        if (aSTNode == null) {
            XPathElementImpl.$$$reportNull$$$0(4);
        }
        return aSTNode;
    }

    public XPathFile getContainingFile() {
        return (XPathFile)super.getContainingFile();
    }

    @Override
    public ContextProvider getXPathContext() {
        return ContextProvider.getContextProvider(super.getContainingFile());
    }

    @Override
    public XPathVersion getXPathVersion() {
        return this.getContainingFile().getXPathVersion();
    }

    protected String unexpectedPsiAssertion() {
        PsiTreeDebugBuilder builder = new PsiTreeDebugBuilder();
        return "Unexpected PSI structure: " + builder.psiToString((PsiElement)this) + "--\ninside: " + builder.psiToString((PsiElement)this.getContainingFile());
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XPathElementImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof XPathElementVisitor) {
            this.accept((XPathElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathElement(this);
    }

    public final String getUnescapedText() {
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)this)) {
            return this.getText();
        }
        return InjectedLanguageManager.getInstance((Project)this.getProject()).getUnescapedText((PsiElement)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/XPathElementImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/XPathElementImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

