/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.references.SimpleAttributeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReference
extends SimpleAttributeReference
implements EmptyResolveMessageProvider {
    private final TextRange myRange;

    public PrefixReference(XmlAttribute attribute) {
        super(attribute);
        this.myRange = PrefixReference.getPrefixRange(this.myAttribute);
    }

    public PrefixReference(XmlAttribute attribute, TextRange range) {
        super(attribute);
        this.myRange = range;
    }

    public static TextRange getPrefixRange(XmlAttribute attribute) {
        String value = attribute.getValue();
        int p = value.indexOf(58);
        if (p == -1) {
            return TextRange.from((int)0, (int)0);
        }
        return TextRange.from((int)0, (int)p);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PrefixReference.$$$reportNull$$$0(0);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    protected TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            PrefixReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Override
    @Nullable
    public PsiElement resolveImpl() {
        return XsltNamespaceContext.resolvePrefix(this.getCanonicalText(), (XmlElement)this.myAttribute);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Undeclared namespace prefix ''{0}''" == null) {
            PrefixReference.$$$reportNull$$$0(2);
        }
        return "Undeclared namespace prefix ''{0}''";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/references/PrefixReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

