/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.ide.DataManager;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class RenameVariableFix
extends AbstractFix {
    private final XsltElement myElement;
    private final String myPlace;

    public RenameVariableFix(XmlTag tag, String place) {
        this.myElement = XsltElementFactory.getInstance().wrapElement(tag, XsltElement.class);
        this.myPlace = place;
    }

    @NotNull
    public String getText() {
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(this.myElement.getLanguage())).getType((PsiElement)this.myElement);
        String string = "Rename " + this.myPlace + " " + StringUtil.capitalize((String)type);
        if (string == null) {
            RenameVariableFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RenameVariableFix.$$$reportNull$$$0(1);
        }
        return this.myElement.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            RenameVariableFix.$$$reportNull$$$0(2);
        }
        RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{this.myElement}, DataManager.getInstance().getDataContext());
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/RenameVariableFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/RenameVariableFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

