/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001*\u00020\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0006*\u00020\u0002H\u0002\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0001\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0002H\u0002\u001a2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003*\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u0018\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014\u001a \u0010\u0015\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u0012\u0010\u0017\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0018"}, d2={"buildGraph", "", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "", "globalCatchBlock", "collectFinallyPaths", "", "collectNodesToSplit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "breakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectTargetBlocks", "collectVariablesSurvivingBetweenBlocks", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "localVariables", "parameters", "replaceCoroutineFlowStatements", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "replaceLocalVariables", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "replaceSpecialReferences", "js.translator"})
public final class CoroutinePassesKt {
    @NotNull
    public static final Set<JsNode> collectNodesToSplit(@NotNull JsNode $receiver, @NotNull Map<JsContinue, ? extends JsStatement> breakContinueTargets) {
        int countBefore;
        int countAfter;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(breakContinueTargets, "breakContinueTargets");
        JsNode root2 = $receiver;
        Set nodes = new LinkedHashSet();
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(nodes, root2, breakContinueTargets){
            private boolean childrenInSet;
            private int finallyLevel;
            final /* synthetic */ Set $nodes;
            final /* synthetic */ JsNode $root;
            final /* synthetic */ Map $breakContinueTargets;

            public final boolean getChildrenInSet() {
                return this.childrenInSet;
            }

            public final void setChildrenInSet(boolean bl) {
                this.childrenInSet = bl;
            }

            public final int getFinallyLevel() {
                return this.finallyLevel;
            }

            public final void setFinallyLevel(int n) {
                this.finallyLevel = n;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitExpressionStatement(x);
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.expression");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    Collection collection = this.$nodes;
                    JsExpression jsExpression2 = x.getExpression();
                    collection.add(jsExpression2);
                    this.childrenInSet = true;
                } else {
                    Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x.getExpression());
                    if (assignment != null) {
                        JsExpression jsExpression3 = assignment.getSecond();
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "assignment.second");
                        if (MetadataProperties.isSuspend(jsExpression3)) {
                            Collection collection = this.$nodes;
                            JsExpression jsExpression4 = assignment.getSecond();
                            collection.add(jsExpression4);
                            this.childrenInSet = true;
                        }
                    }
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitReturn(x);
                if (this.$nodes.contains(this.$root) || this.finallyLevel > 0) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement breakTarget;
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitBreak(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(breakTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement continueTarget;
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitContinue(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(continueTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitTry(@NotNull JsTry x) {
                int n;
                Intrinsics.checkParameterIsNotNull(x, "x");
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + 1;
                }
                super.visitTry(x);
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + -1;
                }
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                boolean oldChildrenInSet = this.childrenInSet;
                this.childrenInSet = false;
                node.acceptChildren(this);
                if (this.childrenInSet) {
                    Collection collection = this.$nodes;
                    collection.add(node);
                } else {
                    this.childrenInSet = oldChildrenInSet;
                }
            }
            {
                this.$nodes = $captured_local_variable$0;
                this.$root = $captured_local_variable$1;
                this.$breakContinueTargets = $captured_local_variable$2;
            }
        };
        do {
            countBefore = nodes.size();
            visitor2.accept($receiver);
        } while ((countAfter = nodes.size()) != countBefore);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceCoroutineFlowStatements(@NotNull List<CoroutineBlock> $receiver, @NotNull CoroutineTransformationContext context) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)$receiver);
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue $index_block = (IndexedValue)element$iv$iv;
            int index2 = $index_block.component1();
            CoroutineBlock block = (CoroutineBlock)$index_block.component2();
            Pair<CoroutineBlock, Integer> pair = new Pair<CoroutineBlock, Integer>(block, index2);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map blockIndexes = destination$iv$iv;
        JsVisitorWithContextImpl blockReplacementVisitor2 = new JsVisitorWithContextImpl(context, blockIndexes){
            final /* synthetic */ CoroutineTransformationContext $context;
            final /* synthetic */ Map $blockIndexes;

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsDebugger x, @NotNull JsContext<? super JsStatement> ctx) {
                List<CoroutineBlock> finallyPath;
                Object rhs;
                CoroutineBlock exceptionTarget;
                Unit unit;
                JsExpressionStatement $receiver;
                JsContext<? super JsStatement> jsContext;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                CoroutineBlock target = CoroutineMetadataPropertiesKt.getTargetBlock(x);
                if (target != null) {
                    JsExpressionStatement jsExpressionStatement;
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(target);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsIntLiteral rhs2 = new JsIntLiteral(((Number)v).intValue());
                    JsExpressionStatement jsExpressionStatement2 = jsExpressionStatement = new JsExpressionStatement(JsAstUtils.assignment(lhs, rhs2).source(x.getSource()));
                    jsContext = ctx;
                    CoroutineMetadataPropertiesKt.setTargetBlock($receiver, true);
                    unit = Unit.INSTANCE;
                    jsContext.replaceMe((JsNode)jsExpressionStatement);
                }
                if ((exceptionTarget = CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)) != null) {
                    void $receiver2;
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getExceptionStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(exceptionTarget);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    rhs = new JsIntLiteral(((Number)v).intValue());
                    JsExpressionStatement $i$a$1$apply = $receiver = new JsExpressionStatement(JsAstUtils.assignment(lhs, (JsExpression)rhs).source(x.getSource()));
                    jsContext = ctx;
                    CoroutineMetadataPropertiesKt.setTargetExceptionBlock((JsExpressionStatement)$receiver2, true);
                    unit = Unit.INSTANCE;
                    jsContext.replaceMe((JsNode)$receiver);
                }
                if ((finallyPath = CoroutineMetadataPropertiesKt.getFinallyPath(x)) != null) {
                    rhs = finallyPath;
                    if (!rhs.isEmpty()) {
                        void $receiver3;
                        JsExpressionStatement jsExpressionStatement;
                        Collection<JsIntLiteral> collection;
                        JsExpressionStatement $receiver$iv$iv;
                        Iterable $receiver$iv;
                        JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getFinallyPathName(), JsAstUtils.stateMachineReceiver());
                        Iterable $i$a$2$apply = $receiver$iv = (Iterable)finallyPath;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                        Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void it;
                            T item$iv$iv = iterator2.next();
                            CoroutineBlock coroutineBlock = (CoroutineBlock)item$iv$iv;
                            collection = destination$iv$iv;
                            V v = this.$blockIndexes.get(it);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            JsIntLiteral jsIntLiteral = new JsIntLiteral(((Number)v).intValue());
                            collection.add(jsIntLiteral);
                        }
                        collection = (List)destination$iv$iv;
                        List list2 = collection;
                        JsArrayLiteral rhs3 = new JsArrayLiteral(list2);
                        $receiver$iv$iv = jsExpressionStatement = new JsExpressionStatement(JsAstUtils.assignment(lhs, rhs3).source(x.getSource()));
                        jsContext = ctx;
                        CoroutineMetadataPropertiesKt.setFinallyPath((JsExpressionStatement)$receiver3, true);
                        unit = Unit.INSTANCE;
                        jsContext.replaceMe((JsNode)jsExpressionStatement);
                    } else {
                        ctx.removeMe();
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$blockIndexes = $captured_local_variable$1;
            }
        };
        Iterable $receiver$iv2 = $receiver;
        for (Object element$iv : $receiver$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            blockReplacementVisitor2.accept((JsNode)it.getJsBlock());
        }
    }

    @NotNull
    public static final Map<CoroutineBlock, Set<CoroutineBlock>> buildGraph(@NotNull CoroutineBlock $receiver, @Nullable CoroutineBlock globalCatchBlock) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set visitedBlocks = new LinkedHashSet();
        Map graph2 = new LinkedHashMap();
        Function1<CoroutineBlock, Unit> visitBlock$ = new Function1<CoroutineBlock, Unit>($receiver, visitedBlocks, graph2, globalCatchBlock){
            final /* synthetic */ CoroutineBlock receiver$0;
            final /* synthetic */ Set $visitedBlocks;
            final /* synthetic */ Map $graph;
            final /* synthetic */ CoroutineBlock $globalCatchBlock;

            public final void invoke(@NotNull CoroutineBlock block) {
                Object object;
                Collection<CoroutineBlock> finallyPath22;
                Intrinsics.checkParameterIsNotNull(block, "block");
                if (this.$visitedBlocks.contains(block)) {
                    return;
                }
                for (Collection<CoroutineBlock> finallyPath22 : CoroutinePassesKt.access$collectFinallyPaths(block)) {
                    for (Pair<T, R> object22 : CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(block), (Iterable)finallyPath22), (Iterable)finallyPath22)) {
                        Object object2;
                        CoroutineBlock finallySource = (CoroutineBlock)object22.component1();
                        CoroutineBlock finallyTarget = (CoroutineBlock)object22.component2();
                        Object $receiver$iv = this.$graph;
                        V value$iv = $receiver$iv.get(finallySource);
                        if (value$iv == null) {
                            Set answer$iv = new LinkedHashSet<E>();
                            $receiver$iv.put(finallySource, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        if (!((Set)object2).add(finallyTarget)) continue;
                        $receiver$iv = this.$visitedBlocks;
                        $receiver$iv.remove(finallySource);
                    }
                }
                finallyPath22 = this.$visitedBlocks;
                finallyPath22.add(block);
                Object $receiver$iv = this.$graph;
                V v = $receiver$iv.get(block);
                if (v == null) {
                    Set answer$iv = new LinkedHashSet<E>();
                    $receiver$iv.put(block, answer$iv);
                    object = answer$iv;
                } else {
                    object = v;
                }
                Set successors = (Set)object;
                $receiver$iv = successors;
                Iterable iterable = CoroutinePassesKt.access$collectTargetBlocks(block);
                CollectionsKt.addAll($receiver$iv, iterable);
                if (Intrinsics.areEqual(block, this.receiver$0) && this.$globalCatchBlock != null) {
                    $receiver$iv = successors;
                    CoroutineBlock coroutineBlock = this.$globalCatchBlock;
                    $receiver$iv.add(coroutineBlock);
                }
                $receiver$iv = successors;
                Iterator<T> iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv = iterator2.next();
                    CoroutineBlock p1 = (CoroutineBlock)element$iv;
                    this.invoke(p1);
                }
            }
            {
                this.receiver$0 = coroutineBlock;
                this.$visitedBlocks = set;
                this.$graph = map2;
                this.$globalCatchBlock = coroutineBlock2;
                super(1);
            }
        };
        visitBlock$.invoke($receiver);
        return graph2;
    }

    private static final Set<CoroutineBlock> collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        Set targetBlocks = new LinkedHashSet();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(targetBlocks){
            final /* synthetic */ Set $targetBlocks;

            public void visitDebugger(@NotNull JsDebugger x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Collection collection = this.$targetBlocks;
                Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)), (Iterable)CollectionsKt.listOfNotNull(CoroutineMetadataPropertiesKt.getTargetBlock(x)));
                CollectionsKt.addAll(collection, iterable);
            }
            {
                this.$targetBlocks = $captured_local_variable$0;
            }
        });
        return targetBlocks;
    }

    private static final List<List<CoroutineBlock>> collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        List finallyPaths = new ArrayList();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(finallyPaths){
            final /* synthetic */ List $finallyPaths;

            public void visitDebugger(@NotNull JsDebugger x) {
                block0: {
                    List<CoroutineBlock> list2;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    List<CoroutineBlock> list3 = CoroutineMetadataPropertiesKt.getFinallyPath(x);
                    if (list3 == null) break block0;
                    List<CoroutineBlock> it = list2 = list3;
                    Collection collection = this.$finallyPaths;
                    collection.add(it);
                }
            }
            {
                this.$finallyPaths = $captured_local_variable$0;
            }
        });
        return finallyPaths;
    }

    public static final void replaceSpecialReferences(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(context){
            final /* synthetic */ CoroutineTransformationContext $context;

            public void endVisit(@NotNull JsThisRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                ctx.replaceMe((JsNode)new JsNameRef(this.$context.getReceiverFieldName(), (JsExpression)new JsThisRef()));
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.getCoroutineReceiver(x)) {
                    ctx.replaceMe((JsNode)new JsThisRef());
                } else if (MetadataProperties.getCoroutineController(x)) {
                    void $receiver;
                    JsNameRef jsNameRef;
                    JsNameRef jsNameRef2 = jsNameRef = new JsNameRef(this.$context.getControllerFieldName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects((HasMetadata)$receiver, SideEffectKind.PURE);
                    Unit unit = Unit.INSTANCE;
                    jsContext.replaceMe((JsNode)jsNameRef);
                } else if (MetadataProperties.getCoroutineResult(x)) {
                    JsNameRef jsNameRef;
                    JsNameRef $receiver = jsNameRef = new JsNameRef(this.$context.getMetadata().getResultName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                    Unit unit = Unit.INSTANCE;
                    jsContext.replaceMe((JsNode)jsNameRef);
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public static final Set<JsName> collectVariablesSurvivingBetweenBlocks(@NotNull List<CoroutineBlock> $receiver, @NotNull Set<? extends JsName> localVariables, @NotNull Set<? extends JsName> parameters) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(localVariables, "localVariables");
        Intrinsics.checkParameterIsNotNull(parameters, "parameters");
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        var6_6 = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            var10_15 = destination$iv$iv;
            it = (JsName)element$iv$iv;
            var13_17 = TuplesKt.to(it, (Set)new LinkedHashSet<E>());
            var10_15.put(var13_17.getFirst(), var13_17.getSecond());
        }
        varDefinedIn = destination$iv$iv;
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = destination$iv$iv;
            it = (JsName)element$iv$iv;
            $i$f$associateTo = TuplesKt.to(it, (Set)new LinkedHashSet<E>());
            it.put($i$f$associateTo.getFirst(), $i$f$associateTo.getSecond());
        }
        varDeclaredIn = destination$iv$iv;
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (E element$iv$iv : $receiver$iv$iv) {
            it = destination$iv$iv;
            it = (JsName)element$iv$iv /* !! */ ;
            $i$f$associateTo = TuplesKt.to(it, (Set)new LinkedHashSet<E>());
            it.put($i$f$associateTo.getFirst(), $i$f$associateTo.getSecond());
        }
        varUsedIn = destination$iv$iv;
        for (Object $receiver$iv : CollectionsKt.withIndex((Iterable)$receiver)) {
            blockIndex = $receiver$iv.component1();
            block = (CoroutineBlock)$receiver$iv.component2();
            for (JsStatement statement : block.getStatements()) {
                statement.accept(new RecursiveJsVisitor(varUsedIn, blockIndex, varDeclaredIn, varDefinedIn){
                    final /* synthetic */ Map $varUsedIn;
                    final /* synthetic */ int $blockIndex;
                    final /* synthetic */ Map $varDeclaredIn;
                    final /* synthetic */ Map $varDefinedIn;

                    public void visitNameRef(@NotNull JsNameRef nameRef) {
                        block0: {
                            Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                            super.visitNameRef(nameRef);
                            Map map2 = this.$varUsedIn;
                            JsName jsName = nameRef.getName();
                            Set set = (Set)map2.get(jsName);
                            if (set == null) break block0;
                            set.add(this.$blockIndex);
                        }
                    }

                    public void visit(@NotNull JsVars.JsVar x) {
                        Intrinsics.checkParameterIsNotNull(x, "x");
                        Set set = (Set)this.$varDeclaredIn.get(x.getName());
                        if (set != null) {
                            set.add(this.$blockIndex);
                        }
                        if (x.getInitExpression() != null) {
                            Set set2 = (Set)this.$varDefinedIn.get(x.getName());
                            if (set2 != null) {
                                set2.add(this.$blockIndex);
                            }
                        }
                        super.visit(x);
                    }

                    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                        Intrinsics.checkParameterIsNotNull(x, "x");
                        JsExpression lhs = x.getArg1();
                        JsBinaryOperator jsBinaryOperator = x.getOperator();
                        Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperator, "x.operator");
                        if (jsBinaryOperator.isAssignment() && lhs instanceof JsNameRef) {
                            Map map2 = this.$varDefinedIn;
                            JsName jsName = ((JsNameRef)lhs).getName();
                            Set set = (Set)map2.get(jsName);
                            if (set != null) {
                                boolean bl;
                                boolean it = bl = set.add(this.$blockIndex);
                                this.accept((JsNode)x.getArg2());
                                return;
                            }
                        }
                        super.visitBinaryExpression(x);
                    }

                    public void visitFunction(@NotNull JsFunction x) {
                        block1: {
                            JsName jsName;
                            Intrinsics.checkParameterIsNotNull(x, "x");
                            JsName jsName2 = x.getName();
                            if (jsName2 == null) break block1;
                            JsName it = jsName = jsName2;
                            Set set = (Set)this.$varDefinedIn.get(it);
                            if (set != null) {
                                set.add(this.$blockIndex);
                            }
                        }
                    }

                    public void visitLabel(@NotNull JsLabel x) {
                        Intrinsics.checkParameterIsNotNull(x, "x");
                        this.accept((JsNode)x.getStatement());
                    }

                    public void visitBreak(@NotNull JsBreak x) {
                        Intrinsics.checkParameterIsNotNull(x, "x");
                    }

                    public void visitContinue(@NotNull JsContinue x) {
                        Intrinsics.checkParameterIsNotNull(x, "x");
                    }
                    {
                        this.$varUsedIn = $captured_local_variable$0;
                        this.$blockIndex = $captured_local_variable$1;
                        this.$varDeclaredIn = $captured_local_variable$2;
                        this.$varDefinedIn = $captured_local_variable$3;
                    }
                });
            }
        }
        isLocalInBlock$ = new Function1<JsName, Boolean>(varDefinedIn, varUsedIn, varDeclaredIn){
            final /* synthetic */ Map $varDefinedIn;
            final /* synthetic */ Map $varUsedIn;
            final /* synthetic */ Map $varDeclaredIn;

            public final boolean invoke(@NotNull JsName $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                V v = this.$varDefinedIn.get($receiver);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Set def = (Set)v;
                V v2 = this.$varUsedIn.get($receiver);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                Set use = (Set)v2;
                V v3 = this.$varDeclaredIn.get($receiver);
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                Set decl = (Set)v3;
                if (def.size() == 1 && use.size() == 1) {
                    Collection collection;
                    int singleUse;
                    int singleDef = ((Number)CollectionsKt.single(def)).intValue();
                    return singleDef == (singleUse = ((Number)CollectionsKt.single(use)).intValue()) && !(collection = (Collection)decl).isEmpty();
                }
                return use.isEmpty();
            }
            {
                this.$varDefinedIn = map2;
                this.$varUsedIn = map3;
                this.$varDeclaredIn = map4;
                super(1);
            }
        };
        blockIndex = $receiver$iv = (Iterable)localVariables;
        destination$iv$iv = new ArrayList<E>();
        for (E element$iv$iv : $receiver$iv$iv) {
            block12: {
                block11: {
                    localVar = (JsName)element$iv$iv /* !! */ ;
                    if (!parameters.contains(localVar)) break block11;
                    v0 = varUsedIn.get(localVar);
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!((Set)v0).isEmpty()) ** GOTO lbl-1000
                    v1 = varDefinedIn.get(localVar);
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!((Set)v1).isEmpty()) ** GOTO lbl-1000
                    v2 = varDeclaredIn.get(localVar);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Set)v2).isEmpty()) {
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v3 = false;
                    }
                    break block12;
                }
                v3 = isLocalInBlock$.invoke(localVar);
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv /* !! */ );
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    public static final void replaceLocalVariables(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context, @NotNull Set<? extends JsName> localVariables) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(localVariables, "localVariables");
        CoroutinePassesKt.replaceSpecialReferences($receiver, context);
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(localVariables, context){
            final /* synthetic */ Set $localVariables;
            final /* synthetic */ CoroutineTransformationContext $context;

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsFunction x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Set<Object> freeVars = CollectionsKt.intersect((Iterable)CollectUtilsKt.collectFreeVariables(x), this.$localVariables);
                Collection collection = freeVars;
                if (!collection.isEmpty()) {
                    Map map2;
                    void $receiver$iv$iv;
                    Object freeVar22;
                    Object object;
                    Object object2;
                    Collection $receiver$iv$iv2;
                    JsFunctionScope jsFunctionScope = x.getScope();
                    Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "x.scope");
                    JsFunction wrapperFunction = new JsFunction(jsFunctionScope.getParent(), new JsBlock(), "");
                    JsInvocation wrapperInvocation = new JsInvocation((JsExpression)wrapperFunction, new JsExpression[0]);
                    JsBlock jsBlock = wrapperFunction.getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsBlock, "wrapperFunction.body");
                    Collection collection2 = jsBlock.getStatements();
                    JsReturn jsReturn = new JsReturn(x);
                    collection2.add(jsReturn);
                    Iterable $receiver$iv = freeVars;
                    int capacity$iv232 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                    Iterable iterable = $receiver$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv232);
                    for (T element$iv$iv : $receiver$iv$iv2) {
                        object2 = destination$iv$iv;
                        JsName it = (JsName)element$iv$iv;
                        object = TuplesKt.to(it, JsScope.declareTemporaryName(it.getIdent()));
                        object2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
                    }
                    Map nameMap = destination$iv$iv;
                    for (Object freeVar22 : freeVars) {
                        $receiver$iv$iv2 = wrapperFunction.getParameters();
                        V v = nameMap.get(freeVar22);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        destination$iv$iv = new JsParameter((JsName)v);
                        $receiver$iv$iv2.add(destination$iv$iv);
                        $receiver$iv$iv2 = wrapperInvocation.getArguments();
                        destination$iv$iv = new JsNameRef(this.$context.getFieldName((JsName)freeVar22), (JsExpression)new JsThisRef());
                        $receiver$iv$iv2.add(destination$iv$iv);
                    }
                    freeVar22 = nameMap;
                    JsNode jsNode = x.getBody();
                    JsFunction jsFunction = x;
                    Iterable capacity$iv232 = $receiver$iv;
                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($receiver$iv.size()));
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv2;
                        K k = it$iv$iv.getKey();
                        object = (Map.Entry)element$iv$iv$iv;
                        K k2 = k;
                        map2 = map3;
                        JsNameRef jsNameRef = ((JsName)it.getValue()).makeRef();
                        map2.put(k2, jsNameRef);
                    }
                    map2 = destination$iv$iv2;
                    jsFunction.setBody((JsBlock)RewriteUtilsKt.replaceNames(jsNode, map2));
                    ctx.replaceMe((JsNode)wrapperInvocation);
                }
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (x.getQualifier() == null && CollectionsKt.contains(this.$localVariables, x.getName())) {
                    JsName jsName = x.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name!!");
                    JsName fieldName = this.$context.getFieldName(jsName);
                    ctx.replaceMe((JsNode)new JsNameRef(fieldName, (JsExpression)new JsThisRef()).source(x.getSource()));
                }
            }

            public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
                boolean bl;
                block11: {
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    List<JsVars.JsVar> list2 = x.getVars();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "x.vars");
                    Iterable $receiver$iv = list2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            JsVars.JsVar it;
                            JsVars.JsVar jsVar = it = (JsVars.JsVar)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull(jsVar, "it");
                            if (!this.$localVariables.contains(jsVar.getName())) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                List statements = new ArrayList<E>();
                List<JsVars.JsVar> list3 = x.getVars();
                Intrinsics.checkExpressionValueIsNotNull(list3, "x.vars");
                for (Pair<List<JsVars.JsVar>, S> pair : UtilsKt.splitToRanges(list3, (Function1)new Function1<JsVars.JsVar, Boolean>(this){
                    final /* synthetic */ replaceLocalVariables.visitor.1 this$0;

                    public final boolean invoke(JsVars.JsVar it) {
                        Set set = this.this$0.$localVariables;
                        JsVars.JsVar jsVar = it;
                        Intrinsics.checkExpressionValueIsNotNull(jsVar, "it");
                        return set.contains(jsVar.getName());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })) {
                    Iterable thisCollection$iv;
                    Iterable $receiver$iv;
                    List<JsVars.JsVar> range = pair.component1();
                    boolean shouldReplace = (Boolean)pair.component2();
                    if (shouldReplace) {
                        JsExpressionStatement $receiver$iv$iv;
                        List<JsVars.JsVar> list4 = x.getVars();
                        Intrinsics.checkExpressionValueIsNotNull(list4, "x.vars");
                        Iterable iterable = $receiver$iv = (Iterable)list4;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            JsBinaryOperation jsBinaryOperation;
                            JsVars.JsVar it;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            JsVars.JsVar jsVar = it = (JsVars.JsVar)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull(jsVar, "it");
                            JsName jsName = jsVar.getName();
                            Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name");
                            JsName fieldName = this.$context.getFieldName(jsName);
                            JsExpression initExpression = it.getInitExpression();
                            JsBinaryOperation jsBinaryOperation2 = initExpression != null ? JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), it.getInitExpression()) : null;
                            if (jsBinaryOperation2 == null) continue;
                            JsBinaryOperation it$iv$iv = jsBinaryOperation = jsBinaryOperation2;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List assignments = (List)destination$iv$iv;
                        $receiver$iv = assignments;
                        if (!(!$receiver$iv.isEmpty())) continue;
                        $receiver$iv = statements;
                        $receiver$iv$iv = new JsExpressionStatement(JsAstUtils.newSequence(assignments));
                        $receiver$iv.add($receiver$iv$iv);
                        continue;
                    }
                    Collection collection = statements;
                    $receiver$iv = range;
                    if ($receiver$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    JsVars.JsVar[] jsVarArray = thisCollection$iv.toArray(new JsVars.JsVar[thisCollection$iv.size()]);
                    if (jsVarArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsVars jsVars = new JsVars(Arrays.copyOf(jsVarArray, jsVarArray.length));
                    collection.add(jsVars);
                }
                if (statements.size() == 1) {
                    ctx.replaceMe((JsNode)statements.get(0));
                } else {
                    ctx.removeMe();
                    ctx.addPrevious(statements);
                }
            }
            {
                this.$localVariables = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    @NotNull
    public static final /* synthetic */ List access$collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectFinallyPaths($receiver);
    }

    @NotNull
    public static final /* synthetic */ Set access$collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectTargetBlocks($receiver);
    }
}

