/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListCellRendererWrapper;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class GtkPreferredJComboBoxRendererInspection
extends DevKitInspectionBase {
    private static final String COMBO_BOX_CLASS_NAME = JComboBox.class.getName();
    private static final String[] RIGHT_RENDERER_CLASS_NAMES = new String[]{ListCellRendererWrapper.class.getName(), ColoredListCellRenderer.class.getName()};
    private static final String SETTER_METHOD_NAME = "setRenderer";
    private static final String MESSAGE = "Default ListCellRenderer implementations are known to cause UI artifacts under GTK+ look&feel, so please use ListCellRendererWrapper or ColoredListCellRenderer instead.";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GtkPreferredJComboBoxRendererInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass comboClass;
                super.visitMethodCallExpression(expression);
                Project project = expression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiElement target = expression.getMethodExpression().resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                if (!GtkPreferredJComboBoxRendererInspection.SETTER_METHOD_NAME.equals(method.getName())) {
                    return;
                }
                PsiClass aClass = ((PsiMethod)target).getContainingClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(comboClass = facade.findClass(COMBO_BOX_CLASS_NAME, GlobalSearchScope.allScope((Project)project))), (boolean)true)) {
                    return;
                }
                PsiExpression[] arguments = expression.getArgumentList().getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiType type = arguments[0].getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClass rendererClass = ((PsiClassType)type).resolve();
                for (String rightClassName : RIGHT_RENDERER_CLASS_NAMES) {
                    PsiClass rightClass = facade.findClass(rightClassName, GlobalSearchScope.allScope((Project)project));
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)rendererClass, (PsiClass)rightClass, (boolean)true)) continue;
                    return;
                }
                holder.registerProblem((PsiElement)expression, GtkPreferredJComboBoxRendererInspection.MESSAGE, new LocalQuickFix[0]);
            }
        };
        if (javaElementVisitor == null) {
            GtkPreferredJComboBoxRendererInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/GtkPreferredJComboBoxRendererInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/GtkPreferredJComboBoxRendererInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

