/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyEmptyStatementBodyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Statement with empty body" == null) {
            GroovyEmptyStatementBodyInspection.$$$reportNull$$$0(0);
        }
        return "Statement with empty body";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrIfStatement) {
            return "'#ref' statement has empty branch";
        }
        return "'#ref' statement has empty body";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyEmptyStatementBodyInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitForStatement(@NotNull GrForStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitForStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && Visitor.isEmpty(thenBranch)) {
                this.registerStatementError(statement, statement);
                return;
            }
            GrStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && Visitor.isEmpty(elseBranch)) {
                this.registerStatementError(statement, statement);
            }
        }

        private static boolean isEmpty(GroovyPsiElement body) {
            if (!(body instanceof GrBlockStatement)) {
                return false;
            }
            GrBlockStatement block = (GrBlockStatement)body;
            GrOpenBlock openBlock = block.getBlock();
            PsiElement brace = openBlock.getLBrace();
            if (brace == null) {
                return false;
            }
            PsiElement nextNonWhitespace = PsiUtil.skipWhitespaces(brace.getNextSibling(), true);
            return nextNonWhitespace == openBlock.getRBrace();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

