/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.dataflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.dataflow.WritesCounterDFAInstance;
import org.jetbrains.plugins.groovy.codeInspection.dataflow.WritesCounterSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyVariableCanBeFinalInspection
extends GroovyLocalInspectionBase {
    private static final Function<ProblemDescriptor, PsiModifierList> ID_MODIFIER_LIST_PROVIDER = descriptor2 -> {
        PsiElement identifier = descriptor2.getPsiElement();
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)identifier, PsiVariable.class);
        return variable == null ? null : variable.getModifierList();
    };

    private static void process(@NotNull GrControlFlowOwner owner, @NotNull GrVariable variable, @NotNull ProblemsHolder problemsHolder) {
        if (owner == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(2);
        }
        if (variable.hasModifierProperty("final")) {
            return;
        }
        if (!GroovyVariableCanBeFinalInspection.checkVariableDeclaredInsideScope(owner, variable)) {
            return;
        }
        if (GroovyVariableCanBeFinalInspection.checkVariableAssignedInsideClosureOrAnonymous(owner, variable)) {
            return;
        }
        boolean isParameterTooltip = variable instanceof GrParameter && (((GrParameter)variable).getDeclarationScope() instanceof GrMethod || ((GrParameter)variable).getDeclarationScope() instanceof GrClosableBlock);
        String tooltip = GroovyInspectionBundle.message(isParameterTooltip ? "parameter.can.be.final.tooltip" : "variable.can.be.final.tooltip", variable.getName());
        problemsHolder.registerProblem(variable.getNameIdentifierGroovy(), tooltip, new LocalQuickFix[]{new GrModifierFix(variable, "final", true, ID_MODIFIER_LIST_PROVIDER)});
    }

    private static boolean checkVariableAssignedInsideClosureOrAnonymous(@NotNull GrControlFlowOwner owner, @NotNull GrVariable variable) {
        if (owner == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(4);
        }
        Collection references = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).findAll();
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (!(element instanceof GroovyPsiElement)) continue;
            GroovyPsiElement groovyElement = (GroovyPsiElement)element;
            GroovyPsiElement closure = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)groovyElement, (Class[])new Class[]{GrClosableBlock.class, GrAnonymousClassDefinition.class});
            if (closure == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)closure, (boolean)false) || !PsiUtil.isLValue(groovyElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkVariableDeclaredInsideScope(@NotNull GrControlFlowOwner owner, @NotNull PsiElement variable) {
        if (owner == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(6);
        }
        GrControlFlowOwner scope = owner.getParent() instanceof PsiMethod ? owner.getParent() : owner;
        return PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)variable, (boolean)false);
    }

    @Override
    public void check(final @NotNull GrControlFlowOwner owner, final @NotNull ProblemsHolder problemsHolder) {
        Instruction[] flow;
        DFAEngine<TObjectIntHashMap<GrVariable>> engine;
        List<TObjectIntHashMap<GrVariable>> dfaResult;
        if (owner == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(7);
        }
        if (problemsHolder == null) {
            GroovyVariableCanBeFinalInspection.$$$reportNull$$$0(8);
        }
        if ((dfaResult = (engine = new DFAEngine<TObjectIntHashMap<GrVariable>>(flow = owner.getControlFlow(), new WritesCounterDFAInstance(), new WritesCounterSemilattice())).performDFAWithTimeout()) == null || dfaResult.isEmpty()) {
            return;
        }
        dfaResult.get(dfaResult.size() - 1).forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<GrVariable>(){

            public boolean execute(GrVariable variable, int writesCount) {
                if (writesCount == 1) {
                    GroovyVariableCanBeFinalInspection.process(owner, variable, problemsHolder);
                }
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/dataflow/GroovyVariableCanBeFinalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableAssignedInsideClosureOrAnonymous";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableDeclaredInsideScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

