/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.ILazyParseableElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public class GroovyBlock
implements Block,
ASTBlock {
    protected final ASTNode myNode;
    protected Alignment myAlignment;
    protected final Indent myIndent;
    protected final Wrap myWrap;
    protected final FormattingContext myContext;
    protected List<Block> mySubBlocks;

    public GroovyBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        if (node == null) {
            GroovyBlock.$$$reportNull$$$0(0);
        }
        if (indent == null) {
            GroovyBlock.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GroovyBlock.$$$reportNull$$$0(2);
        }
        this.myAlignment = null;
        this.mySubBlocks = null;
        this.myNode = node;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myContext = context;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            GroovyBlock.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            GroovyBlock.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = new GroovyBlockGenerator(this).generateSubBlocks();
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            GroovyBlock.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        if (this.myAlignment == null) {
            this.myAlignment = this.myContext.getAlignmentProvider().getAlignment(this.myNode.getPsi());
        }
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            GroovyBlock.$$$reportNull$$$0(6);
        }
        return GroovySpacingProcessor.getSpacing(child1, child2, this.myContext);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GroovyFileBase) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(7);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrSwitchStatement) {
            new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (psiParent instanceof GrCaseLabel) {
            ChildAttributes childAttributes = new ChildAttributes(GroovyIndentProcessor.getSwitchCaseIndent(this.getContext().getSettings()), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(8);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrCaseSection) {
            ChildAttributes childAttributes = GroovyIndentProcessor.getChildSwitchIndent((GrCaseSection)psiParent, newChildIndex);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(9);
            }
            return childAttributes;
        }
        if (TokenSets.BLOCK_SET.contains(astNode.getElementType()) || ((Object)((Object)GroovyElementTypes.SWITCH_STATEMENT)).equals(astNode.getElementType())) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(10);
            }
            return childAttributes;
        }
        if (((Object)((Object)GroovyElementTypes.CASE_SECTION)).equals(astNode.getElementType())) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(11);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrBinaryExpression || psiParent instanceof GrConditionalExpression || psiParent instanceof GrCommandArgumentList || psiParent instanceof GrArgumentList || psiParent instanceof GrParameterList || psiParent instanceof GrListOrMap || psiParent instanceof GrAnnotationArgumentList || psiParent instanceof GrVariable || psiParent instanceof GrAssignmentExpression) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(12);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrDocComment || psiParent instanceof GrDocTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(13);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrIfStatement || psiParent instanceof GrLoopStatement) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(14);
            }
            return childAttributes;
        }
        if (psiParent instanceof GrLabeledStatement && newChildIndex == 2) {
            Indent indent = this.getContext().getGroovySettings().INDENT_LABEL_BLOCKS ? Indent.getLabelIndent() : Indent.getNoneIndent();
            ChildAttributes childAttributes = new ChildAttributes(indent, null);
            if (childAttributes == null) {
                GroovyBlock.$$$reportNull$$$0(15);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            GroovyBlock.$$$reportNull$$$0(16);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return GroovyBlock.isIncomplete(this.myNode);
    }

    public static boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node == null) {
            GroovyBlock.$$$reportNull$$$0(17);
        }
        if (node.getElementType() instanceof ILazyParseableElementType) {
            return false;
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && !(lastChild.getElementType() instanceof ILazyParseableElementType) && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || GroovyBlock.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public String toString() {
        return this.getTextRange() + ": " + this.myNode;
    }

    public FormattingContext getContext() {
        return this.myContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

