/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ClosureParamsEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(closure, "2.3")) {
            return null;
        }
        GrParameter[] parameters = closure.getAllParameters();
        if (ClosureParamsEnhancer.containsParametersWithDeclaredType(parameters)) {
            return null;
        }
        List<PsiType[]> fittingSignatures = ClosureParamsEnhancer.findFittingSignatures(closure);
        if (fittingSignatures.size() == 1) {
            PsiType[] expectedSignature = fittingSignatures.get(0);
            return expectedSignature[index];
        }
        return null;
    }

    @NotNull
    public static List<PsiType[]> findFittingSignatures(GrClosableBlock closure) {
        GroovyResolveResult[] variants;
        GrCall call = ClosureParamsEnhancer.findCall(closure);
        if (call == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                ClosureParamsEnhancer.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList expectedSignatures = ContainerUtil.newArrayList();
        for (GroovyResolveResult variant : variants = call.getCallVariants(closure)) {
            expectedSignatures.addAll(ClosureParamsEnhancer.inferExpectedSignatures(variant, call, closure));
        }
        GrParameter[] parameters = closure.getAllParameters();
        List list = ContainerUtil.findAll((Collection)expectedSignatures, types -> ((PsiType[])types).length == parameters.length);
        if (list == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static List<PsiType[]> inferExpectedSignatures(@NotNull GroovyResolveResult variant, @NotNull GrCall call, @NotNull GrClosableBlock closure) {
        if (variant == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(2);
        }
        if (call == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(3);
        }
        if (closure == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(4);
        }
        PsiElement element = variant.getElement();
        while (element instanceof PsiMirrorElement) {
            element = ((PsiMirrorElement)element).getPrototype();
        }
        if (!(element instanceof PsiMethod)) {
            return Collections.emptyList();
        }
        List<Pair<PsiParameter, PsiType>> params = ResolveUtil.collectExpectedParamsByArg(closure, new GroovyResolveResult[]{variant}, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), closure);
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        Pair<PsiParameter, PsiType> pair = params.get(0);
        PsiParameter param = (PsiParameter)pair.getFirst();
        PsiModifierList modifierList = param.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        PsiAnnotation anno = modifierList.findAnnotation("groovy.transform.stc.ClosureParams");
        if (anno == null) {
            return Collections.emptyList();
        }
        PsiClass closureSignatureHint = GrAnnotationUtil.inferClassAttribute(anno, "value");
        if (closureSignatureHint == null) {
            return Collections.emptyList();
        }
        String qnameOfClosureSignatureHint = closureSignatureHint.getQualifiedName();
        if (qnameOfClosureSignatureHint == null) {
            return Collections.emptyList();
        }
        SignatureHintProcessor signatureHintProcessor = SignatureHintProcessor.getHintProcessor(qnameOfClosureSignatureHint);
        if (signatureHintProcessor == null) {
            return Collections.emptyList();
        }
        return signatureHintProcessor.inferExpectedSignatures((PsiMethod)element, variant.getSubstitutor(), SignatureHintProcessor.buildOptions(anno));
    }

    private static boolean containsParametersWithDeclaredType(GrParameter[] parameters) {
        return ContainerUtil.find((Object[])parameters, parameter -> parameter.getDeclaredType() != null) != null;
    }

    @Nullable
    private static GrCall findCall(@NotNull GrClosableBlock closure) {
        PsiElement pparent;
        PsiElement parent;
        if (closure == null) {
            ClosureParamsEnhancer.$$$reportNull$$$0(5);
        }
        if ((parent = closure.getParent()) instanceof GrCall && ArrayUtil.contains((Object)closure, (Object[])((GrCall)parent).getClosureArguments())) {
            return (GrCall)parent;
        }
        if (parent instanceof GrArgumentList && (pparent = parent.getParent()) instanceof GrCall) {
            return (GrCall)pparent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findFittingSignatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inferExpectedSignatures";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

