/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfileUtils {
    @NotNull
    public static Set<String> getAllProfiles(@Nullable Beans beans) {
        LinkedHashSet names = ContainerUtil.newLinkedHashSet();
        SpringProfileUtils.processProfiles(beans, (Processor<Beans>)((Processor)nestedBeans -> {
            names.addAll(nestedBeans.getProfile().getNames());
            return true;
        }));
        LinkedHashSet linkedHashSet = names;
        if (linkedHashSet == null) {
            SpringProfileUtils.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    public static boolean processProfiles(@Nullable Beans beans, @NotNull Processor<Beans> processor) {
        if (processor == null) {
            SpringProfileUtils.$$$reportNull$$$0(1);
        }
        if (beans != null) {
            if (!processor.process((Object)beans)) {
                return false;
            }
            for (Beans childrenBeans : beans.getBeansProfiles()) {
                if (SpringProfileUtils.processProfiles(childrenBeans, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isInActiveProfile(@NotNull DomElement value) {
        Beans beans;
        if (value == null) {
            SpringProfileUtils.$$$reportNull$$$0(2);
        }
        if ((beans = (Beans)DomUtil.getParentOfType((DomElement)value, Beans.class, (boolean)true)) != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)value.getXmlElement());
            return SpringProfileUtils.isActiveProfile(beans, model.getActiveProfiles());
        }
        return true;
    }

    public static boolean isInActiveProfile(@NotNull DomElement domElement, @NotNull Set<String> profiles) {
        Beans beans;
        if (domElement == null) {
            SpringProfileUtils.$$$reportNull$$$0(3);
        }
        if (profiles == null) {
            SpringProfileUtils.$$$reportNull$$$0(4);
        }
        if ((beans = (Beans)DomUtil.getParentOfType((DomElement)domElement, Beans.class, (boolean)true)) != null) {
            return SpringProfileUtils.isActiveProfile(beans, profiles);
        }
        return true;
    }

    public static boolean isActiveProfile(@Nullable Beans beans, @Nullable Set<String> activeProfiles) {
        if (beans == null) {
            return false;
        }
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        if (SpringProfileUtils.isActive(beans.getProfile().getNames(), activeProfiles)) {
            Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)beans, Beans.class, (boolean)true);
            return parentBeans == null || SpringProfileUtils.isActiveProfile(parentBeans, activeProfiles);
        }
        if (StringUtil.isEmptyOrSpaces((String)beans.getProfile().getStringValue())) {
            Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)beans, Beans.class, (boolean)true);
            return parentBeans == null || SpringProfileUtils.isActiveProfile(parentBeans, activeProfiles);
        }
        return false;
    }

    public static boolean isActive(@NotNull Set<String> profiles, @NotNull Set<String> activeProfiles) {
        if (profiles == null) {
            SpringProfileUtils.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            SpringProfileUtils.$$$reportNull$$$0(6);
        }
        if (profiles.size() == 1 && profiles.iterator().next().equals("_DEFAULT_PROFILE_NAME_")) {
            return true;
        }
        for (String profile : profiles) {
            String notProfile;
            if (!(profile.startsWith("!") ? !activeProfiles.contains(notProfile = profile.substring(1)) : activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String profilesAsString(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            if ("" == null) {
                SpringProfileUtils.$$$reportNull$$$0(7);
            }
            return "";
        }
        TreeSet<String> profiles = new TreeSet<String>();
        for (String activeProfile : activeProfiles) {
            if ("_DEFAULT_PROFILE_NAME_".equals(activeProfile)) continue;
            profiles.add(activeProfile);
        }
        if (profiles.size() > 1) {
            String string = StringUtil.join(profiles, (String)", ");
            if (string == null) {
                SpringProfileUtils.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = (String)ContainerUtil.getFirstItem(profiles, (Object)"");
        if (string == null) {
            SpringProfileUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static <T extends CommonSpringBean> List<T> filterBeansInActiveProfiles(@NotNull Collection<T> allBeans, @Nullable Set<String> activeProfiles) {
        if (allBeans == null) {
            SpringProfileUtils.$$$reportNull$$$0(10);
        }
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            SmartList smartList = new SmartList(allBeans);
            if (smartList == null) {
                SpringProfileUtils.$$$reportNull$$$0(11);
            }
            return smartList;
        }
        SmartList beansInActiveProfiles = new SmartList();
        for (CommonSpringBean bean : allBeans) {
            SpringProfile profile;
            if (!bean.isValid() || !SpringProfileUtils.isProfileAccepted(profile = bean.getProfile(), activeProfiles)) continue;
            beansInActiveProfiles.add(bean);
        }
        SmartList smartList = beansInActiveProfiles;
        if (smartList == null) {
            SpringProfileUtils.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    public static boolean isProfileAccepted(@NotNull SpringProfile profile, @Nullable Set<String> activeProfiles) {
        if (profile == null) {
            SpringProfileUtils.$$$reportNull$$$0(13);
        }
        if (profile == SpringProfile.DEFAULT || activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        return SpringProfileUtils.isActive(profile.getNames(), activeProfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringProfileUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringProfileUtils";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "profilesAsString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeansInActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processProfiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveProfile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterBeansInActiveProfiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isProfileAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

