/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSpiClassesListJamConverter
extends JamConverter<PsiClass> {
    private final String myConfigKey;

    public SpringSpiClassesListJamConverter(String configKey) {
        this.myConfigKey = configKey;
    }

    @Nullable
    public PsiClass fromString(@Nullable String s, JamStringAttributeElement<PsiClass> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiReference[] references = this.createReferences(context);
        if (references.length != 1) {
            return null;
        }
        return (PsiClass)references[0].resolve();
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiClass> context) {
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringSpiClassesListJamConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringSpiClassReference(this.myConfigKey, literal, context.getStringValue())};
        if (psiReferenceArray == null) {
            SpringSpiClassesListJamConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiClassesListJamConverter", "createReferences"));
    }

    public static class SpringSpiClassReference
    extends PsiReferenceBase<PsiElement> {
        private final String myConfigKey;
        private final String myText;

        private SpringSpiClassReference(String configKey, @NotNull PsiLiteral literal, String text) {
            if (literal == null) {
                SpringSpiClassReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)literal);
            this.myConfigKey = configKey;
            this.myText = text;
        }

        @Nullable
        public PsiElement resolve() {
            if (StringUtil.isEmptyOrSpaces((String)this.myText)) {
                return null;
            }
            return (PsiElement)ContainerUtil.find(this.getRelevantClasses(this.getElement()), psiClass -> this.myText.equals(psiClass.getQualifiedName()));
        }

        @NotNull
        public Object[] getVariants() {
            List<PsiClass> classes = this.getRelevantClasses(this.getElement());
            Object[] objectArray = ContainerUtil.map2Array(classes, LookupElement.class, psiClass -> JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)psiClass.getQualifiedName(), (boolean)true).withPresentableText(StringUtil.notNullize((String)psiClass.getName())));
            if (objectArray == null) {
                SpringSpiClassReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private List<PsiClass> getRelevantClasses(PsiElement literal) {
            if (literal == null) {
                return Collections.emptyList();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return Collections.emptyList();
            }
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            boolean isInTest = moduleFileIndex.isInTestSourceContent(literal.getContainingFile().getOriginalFile().getVirtualFile());
            return SpringSpiManager.getInstance(module).getClassesListValue(isInTest, this.myConfigKey);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

