/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ResettableComponentMatcher;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.timing.Condition;
import org.fest.util.Strings;
import org.fest.util.SystemProperties;

public final class ComponentFoundCondition
extends Condition {
    private final ComponentFinder finder;
    private final ComponentMatcher matcher;
    private final Container root;
    private Component found;
    private final AtomicReference<ComponentLookupException> notFoundError;

    public ComponentFoundCondition(@Nonnull String description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher) {
        if (description == null) {
            ComponentFoundCondition.$$$reportNull$$$0(0);
        }
        if (finder == null) {
            ComponentFoundCondition.$$$reportNull$$$0(1);
        }
        if (matcher == null) {
            ComponentFoundCondition.$$$reportNull$$$0(2);
        }
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(@Nonnull String description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        if (description == null) {
            ComponentFoundCondition.$$$reportNull$$$0(3);
        }
        if (finder == null) {
            ComponentFoundCondition.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            ComponentFoundCondition.$$$reportNull$$$0(5);
        }
        this((Description)new BasicDescription(description), finder, matcher, root);
    }

    public ComponentFoundCondition(@Nonnull Description description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher) {
        if (description == null) {
            ComponentFoundCondition.$$$reportNull$$$0(6);
        }
        if (finder == null) {
            ComponentFoundCondition.$$$reportNull$$$0(7);
        }
        if (matcher == null) {
            ComponentFoundCondition.$$$reportNull$$$0(8);
        }
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(@Nonnull Description description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        if (description == null) {
            ComponentFoundCondition.$$$reportNull$$$0(9);
        }
        if (finder == null) {
            ComponentFoundCondition.$$$reportNull$$$0(10);
        }
        if (matcher == null) {
            ComponentFoundCondition.$$$reportNull$$$0(11);
        }
        super(description);
        this.notFoundError = new AtomicReference();
        this.finder = finder;
        this.matcher = matcher;
        this.root = root;
    }

    @Override
    public boolean test() {
        boolean matchFound = false;
        try {
            this.found = this.finder.find(this.root, this.matcher);
            matchFound = true;
        }
        catch (ComponentLookupException e) {
            this.notFoundError.set(e);
        }
        this.resetMatcher(matchFound);
        if (matchFound) {
            this.notFoundError.set(null);
        }
        return matchFound;
    }

    private void resetMatcher(boolean matchFound) {
        if (!(this.matcher instanceof ResettableComponentMatcher)) {
            return;
        }
        ((ResettableComponentMatcher)this.matcher).reset(matchFound);
    }

    @Override
    @Nonnull
    protected String descriptionAddendum() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            if ("" == null) {
                ComponentFoundCondition.$$$reportNull$$$0(12);
            }
            return "";
        }
        String string = Strings.concat((Object[])new Object[]{SystemProperties.lineSeparator(), error.getMessage()});
        if (string == null) {
            ComponentFoundCondition.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Component found() {
        return this.found;
    }

    public Collection<? extends Component> duplicatesFound() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            return Collections.emptyList();
        }
        return error.found();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/ComponentFoundCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/ComponentFoundCondition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "descriptionAddendum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

