/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;

public final class JTextComponentMatcher
extends NamedComponentMatcherTemplate<JTextComponent> {
    private Object text;

    @Nonnull
    public static JTextComponentMatcher withName(@Nullable String name) {
        JTextComponentMatcher jTextComponentMatcher = new JTextComponentMatcher(name, JTextComponentMatcher.anyValue());
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(0);
        }
        return jTextComponentMatcher;
    }

    @Nonnull
    public static JTextComponentMatcher withText(@Nonnull String text) {
        if (text == null) {
            JTextComponentMatcher.$$$reportNull$$$0(1);
        }
        JTextComponentMatcher jTextComponentMatcher = new JTextComponentMatcher(JTextComponentMatcher.anyValue(), (Object)text);
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(2);
        }
        return jTextComponentMatcher;
    }

    @Nonnull
    public static JTextComponentMatcher withText(@Nonnull Pattern textPattern) {
        if (textPattern == null) {
            JTextComponentMatcher.$$$reportNull$$$0(3);
        }
        JTextComponentMatcher jTextComponentMatcher = new JTextComponentMatcher(JTextComponentMatcher.anyValue(), (Object)textPattern);
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(4);
        }
        return jTextComponentMatcher;
    }

    @Nonnull
    public static JTextComponentMatcher any() {
        JTextComponentMatcher jTextComponentMatcher = new JTextComponentMatcher(JTextComponentMatcher.anyValue(), JTextComponentMatcher.anyValue());
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(5);
        }
        return jTextComponentMatcher;
    }

    private JTextComponentMatcher(@Nullable Object name, @Nullable Object text) {
        super(JTextComponent.class, name);
        this.text = text;
    }

    @Nonnull
    public JTextComponentMatcher andText(@Nonnull String newText) {
        if (newText == null) {
            JTextComponentMatcher.$$$reportNull$$$0(6);
        }
        this.text = newText;
        JTextComponentMatcher jTextComponentMatcher = this;
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(7);
        }
        return jTextComponentMatcher;
    }

    @Nonnull
    public JTextComponentMatcher andText(@Nonnull Pattern textPattern) {
        if (textPattern == null) {
            JTextComponentMatcher.$$$reportNull$$$0(8);
        }
        this.text = textPattern;
        JTextComponentMatcher jTextComponentMatcher = this;
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(9);
        }
        return jTextComponentMatcher;
    }

    @Nonnull
    public JTextComponentMatcher andShowing() {
        this.requireShowing(true);
        JTextComponentMatcher jTextComponentMatcher = this;
        if (jTextComponentMatcher == null) {
            JTextComponentMatcher.$$$reportNull$$$0(10);
        }
        return jTextComponentMatcher;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JTextComponent textComponent) {
        if (textComponent == null) {
            JTextComponentMatcher.$$$reportNull$$$0(11);
        }
        return this.isNameMatching(textComponent.getName()) && this.arePropertyValuesMatching(this.text, textComponent.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/matcher/JTextComponentMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/matcher/JTextComponentMatcher";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "any";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "andText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "andShowing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withText";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "andText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

