/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JTreeAddRootIfInvisibleTask;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JTreeMatchingPathQuery {
    @Nonnull
    @RunsInEDT
    static TreePath verifyJTreeIsReadyAndFindMatchingPath(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        if (tree == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(1);
        }
        if (pathFinder == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(2);
        }
        TreePath result = GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            @Nonnull
            protected TreePath executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                TreePath treePath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
                if (treePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return treePath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/JTreeMatchingPathQuery$1", "executeInEDT"));
            }
        });
        TreePath treePath = (TreePath)Preconditions.checkNotNull((Object)result);
        if (treePath == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(3);
        }
        return treePath;
    }

    @Nonnull
    @RunsInEDT
    static TreePath matchingPathFor(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        if (tree == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(4);
        }
        if (path == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(5);
        }
        if (pathFinder == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(6);
        }
        TreePath result = GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            @Nonnull
            protected TreePath executeInEDT() {
                TreePath treePath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
                if (treePath == null) {
                    2.$$$reportNull$$$0(0);
                }
                return treePath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/JTreeMatchingPathQuery$2", "executeInEDT"));
            }
        });
        TreePath treePath = (TreePath)Preconditions.checkNotNull((Object)result);
        if (treePath == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(7);
        }
        return treePath;
    }

    @Nonnull
    @RunsInCurrentThread
    static TreePath matchingPathWithRootIfInvisible(@Nonnull JTree tree, @Nonnull String path, @Nonnull JTreePathFinder pathFinder) {
        if (tree == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(8);
        }
        if (path == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(9);
        }
        if (pathFinder == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(10);
        }
        TreePath matchingPath = pathFinder.findMatchingPath(tree, path);
        TreePath treePath = JTreeAddRootIfInvisibleTask.addRootIfInvisible(tree, matchingPath);
        if (treePath == null) {
            JTreeMatchingPathQuery.$$$reportNull$$$0(11);
        }
        return treePath;
    }

    private JTreeMatchingPathQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFinder";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTreeMatchingPathQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTreeMatchingPathQuery";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyJTreeIsReadyAndFindMatchingPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingPathFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingPathWithRootIfInvisible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "verifyJTreeIsReadyAndFindMatchingPath";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchingPathFor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchingPathWithRootIfInvisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

