/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import javax.annotation.Nonnull;
import javax.swing.KeyStroke;
import org.fest.util.Preconditions;

public class KeyStrokeMapping {
    private final char character;
    private final KeyStroke keyStroke;

    @Nonnull
    public static KeyStrokeMapping mapping(char character, int keyCode, int modifiers) {
        KeyStrokeMapping keyStrokeMapping = new KeyStrokeMapping(character, keyCode, modifiers);
        if (keyStrokeMapping == null) {
            KeyStrokeMapping.$$$reportNull$$$0(0);
        }
        return keyStrokeMapping;
    }

    public KeyStrokeMapping(char character, int keyCode, int modifiers) {
        this(character, (KeyStroke)Preconditions.checkNotNull((Object)KeyStroke.getKeyStroke(keyCode, modifiers)));
    }

    public KeyStrokeMapping(char character, @Nonnull KeyStroke keyStroke) {
        if (keyStroke == null) {
            KeyStrokeMapping.$$$reportNull$$$0(1);
        }
        this.character = character;
        this.keyStroke = keyStroke;
    }

    public char character() {
        return this.character;
    }

    @Nonnull
    public KeyStroke keyStroke() {
        KeyStroke keyStroke = this.keyStroke;
        if (keyStroke == null) {
            KeyStrokeMapping.$$$reportNull$$$0(2);
        }
        return keyStroke;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof KeyStrokeMapping)) {
            return false;
        }
        KeyStrokeMapping other = (KeyStrokeMapping)o;
        return this.character == other.character && this.keyStroke.getKeyCode() == other.keyStroke.getKeyCode() && this.keyStroke.getModifiers() == other.keyStroke.getModifiers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.character;
        if (this.keyStroke != null) {
            result = prime * result + this.keyStroke.getKeyCode();
            result = prime * result + this.keyStroke.getModifiers();
        }
        return result;
    }

    public String toString() {
        String format = "%s[character='%s', keyStroke=%s]";
        return String.format(format, this.getClass().getSimpleName(), String.valueOf(this.character), this.keyStroke.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/keystroke/KeyStrokeMapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mapping";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/keystroke/KeyStrokeMapping";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keyStroke";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

