/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.fest.swing.util.OSFamily;
import org.fest.swing.util.SystemPropertyReader;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

class OSIdentifier {
    private final boolean isWindows;
    private final boolean isWindows9x;
    private final boolean isWindowsXP;
    private final boolean isMacintosh;
    private final boolean isOSX;
    private final boolean isX11;
    private final boolean isSolaris;
    private final boolean isHPUX;
    private final boolean isLinux;
    private final OSFamily osFamily;

    OSIdentifier() {
        this(new SystemPropertyReader());
    }

    @VisibleForTesting
    OSIdentifier(@Nonnull SystemPropertyReader reader) {
        if (reader == null) {
            OSIdentifier.$$$reportNull$$$0(0);
        }
        String osName = ((String)Preconditions.checkNotNull((Object)reader.systemProperty("os.name"))).toLowerCase(Locale.ENGLISH);
        String mrjVersion = reader.systemProperty("mrj.version");
        this.isWindows = osName.startsWith("windows");
        this.isWindows9x = this.isWindows && OSIdentifier.containsAny(osName, "95", "98", "me");
        this.isWindowsXP = this.isWindows && osName.contains("xp");
        this.isMacintosh = mrjVersion != null;
        this.isOSX = this.isMacintosh && osName.contains("os x");
        this.isX11 = !this.isOSX && !this.isWindows;
        this.isSolaris = osName.startsWith("sunos") || osName.startsWith("solaris");
        this.isHPUX = osName.equals("hp-ux");
        this.isLinux = osName.equals("linux");
        this.osFamily = this.findOSFamily();
    }

    private static boolean containsAny(@Nonnull String target, String ... subs) {
        if (target == null) {
            OSIdentifier.$$$reportNull$$$0(1);
        }
        if (subs == null) {
            OSIdentifier.$$$reportNull$$$0(2);
        }
        for (String sub : subs) {
            if (!target.contains(sub)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private OSFamily findOSFamily() {
        if (this.isWindows()) {
            OSFamily oSFamily = OSFamily.WINDOWS;
            if (oSFamily == null) {
                OSIdentifier.$$$reportNull$$$0(3);
            }
            return oSFamily;
        }
        if (this.isMacintosh() || this.isOSX()) {
            OSFamily oSFamily = OSFamily.MAC;
            if (oSFamily == null) {
                OSIdentifier.$$$reportNull$$$0(4);
            }
            return oSFamily;
        }
        if (this.isLinux()) {
            OSFamily oSFamily = OSFamily.LINUX;
            if (oSFamily == null) {
                OSIdentifier.$$$reportNull$$$0(5);
            }
            return oSFamily;
        }
        OSFamily oSFamily = OSFamily.UNIX;
        if (oSFamily == null) {
            OSIdentifier.$$$reportNull$$$0(6);
        }
        return oSFamily;
    }

    boolean isWindows() {
        return this.isWindows;
    }

    boolean isWindows9x() {
        return this.isWindows9x;
    }

    boolean isWindowsXP() {
        return this.isWindowsXP;
    }

    boolean isMacintosh() {
        return this.isMacintosh;
    }

    boolean isOSX() {
        return this.isOSX;
    }

    boolean isX11() {
        return this.isX11;
    }

    boolean isSolaris() {
        return this.isSolaris;
    }

    boolean isHPUX() {
        return this.isHPUX;
    }

    boolean isLinux() {
        return this.isLinux;
    }

    @Nonnull
    OSFamily osFamily() {
        OSFamily oSFamily = this.osFamily;
        if (oSFamily == null) {
            OSIdentifier.$$$reportNull$$$0(7);
        }
        return oSFamily;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subs";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/util/OSIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/util/OSIdentifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOSFamily";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "osFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsAny";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

