/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class AppCompatCallDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("AppCompatMethod", "Using Wrong AppCompat Method", "When using the appcompat library, there are some methods you should be calling instead of the normal ones; for example, `getSupportActionBar()` instead of `getActionBar()`. This lint check looks for calls to the wrong method.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(AppCompatCallDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/tools/support-library/index.html");
    private static final String GET_ACTION_BAR = "getActionBar";
    private static final String START_ACTION_MODE = "startActionMode";
    private static final String SET_PROGRESS_BAR_VIS = "setProgressBarVisibility";
    private static final String SET_PROGRESS_BAR_IN_VIS = "setProgressBarIndeterminateVisibility";
    private static final String SET_PROGRESS_BAR_INDETERMINATE = "setProgressBarIndeterminate";
    private static final String REQUEST_WINDOW_FEATURE = "requestWindowFeature";
    private static final String ERROR_MESSAGE_FORMAT = "Should use `%1$s` instead of `%2$s` name";
    private boolean mDependsOnAppCompat;

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        Boolean dependsOnAppCompat = context.getProject().dependsOn("com.android.support:appcompat-v7");
        this.mDependsOnAppCompat = dependsOnAppCompat != null && dependsOnAppCompat != false;
    }

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(GET_ACTION_BAR, START_ACTION_MODE, SET_PROGRESS_BAR_VIS, SET_PROGRESS_BAR_IN_VIS, SET_PROGRESS_BAR_INDETERMINATE, REQUEST_WINDOW_FEATURE);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod method) {
        if (this.mDependsOnAppCompat && AppCompatCallDetector.isAppBarActivityCall(context, node, (PsiMethod)method)) {
            String name = method.getName();
            String replace = null;
            if (GET_ACTION_BAR.equals(name)) {
                replace = "getSupportActionBar";
            } else if (START_ACTION_MODE.equals(name)) {
                replace = "startSupportActionMode";
            } else if (SET_PROGRESS_BAR_VIS.equals(name)) {
                replace = "setSupportProgressBarVisibility";
            } else if (SET_PROGRESS_BAR_IN_VIS.equals(name)) {
                replace = "setSupportProgressBarIndeterminateVisibility";
            } else if (SET_PROGRESS_BAR_INDETERMINATE.equals(name)) {
                replace = "setSupportProgressBarIndeterminate";
            } else if (REQUEST_WINDOW_FEATURE.equals(name)) {
                replace = "supportRequestWindowFeature";
            }
            if (replace != null) {
                String message = String.format(ERROR_MESSAGE_FORMAT, replace, name);
                context.report(ISSUE, (UElement)node, context.getUastLocation((UElement)node), message);
            }
        }
    }

    private static boolean isAppBarActivityCall(@NonNull JavaContext context, @NonNull UCallExpression node, @NonNull PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Activity", false)) {
            UClass cls = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            return cls != null && InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.support.v7.app.ActionBarActivity");
        }
        return false;
    }

    @Nullable
    public static String getOldCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 2, format);
    }

    @Nullable
    public static String getNewCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 1, format);
    }

    @Nullable
    private static String getMessagePart(@NonNull String errorMessage, int group, @NonNull TextFormat format) {
        List<String> parameters2 = LintUtils.getFormattedParameters(TextFormat.RAW.convertTo(ERROR_MESSAGE_FORMAT, format), errorMessage);
        if (parameters2.size() == 2 && group <= 2) {
            return parameters2.get(group - 1);
        }
        return null;
    }
}

