/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class RecursiveLockImplJava5
implements RecursiveLock {
    volatile Thread owner = null;
    ReentrantLock lock;

    public RecursiveLockImplJava5(boolean bl) {
        this.lock = new ReentrantLock(bl);
    }

    @Override
    public void lock() {
        try {
            if (!this.tryLock(TIMEOUT)) {
                long l = TIMEOUT;
                String string = this.threadName(this.owner);
                String string2 = this.threadName(Thread.currentThread());
                int n = this.getHoldCount();
                String string3 = String.valueOf(this);
                throw new RuntimeException(new StringBuilder(70 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Waited ").append(l).append("ms for: ").append(string).append(" - ").append(string2).append(", with count ").append(n).append(", lock: ").append(string3).toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted", interruptedException);
        }
        this.owner = Thread.currentThread();
    }

    @Override
    public boolean tryLock(long l) throws InterruptedException {
        if (this.lock.tryLock(l, TimeUnit.MILLISECONDS)) {
            this.owner = Thread.currentThread();
            return true;
        }
        return false;
    }

    @Override
    public void unlock() throws RuntimeException {
        this.unlock(null);
    }

    @Override
    public void unlock(Runnable runnable) {
        this.validateLocked();
        this.owner = null;
        if (null != runnable) {
            runnable.run();
        }
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public Thread getOwner() {
        return this.owner;
    }

    @Override
    public boolean isLockedByOtherThread() {
        return this.lock.isLocked() && !this.lock.isHeldByCurrentThread();
    }

    @Override
    public boolean isOwner(Thread thread) {
        return this.lock.isLocked() && this.owner == thread;
    }

    @Override
    public void validateLocked() throws RuntimeException {
        if (!this.lock.isHeldByCurrentThread()) {
            if (!this.lock.isLocked()) {
                String string = String.valueOf(Thread.currentThread());
                throw new RuntimeException(new StringBuilder(12 + String.valueOf(string).length()).append(string).append(": Not locked").toString());
            }
            String string = String.valueOf(Thread.currentThread());
            String string2 = String.valueOf(this.owner);
            throw new RuntimeException(new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": Not owner, owner is ").append(string2).toString());
        }
    }

    @Override
    public int getHoldCount() {
        return this.lock.getHoldCount();
    }

    @Override
    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    private String threadName(Thread thread) {
        String string;
        if (null != thread) {
            String string2 = String.valueOf(thread.getName());
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("<").append(string2).append(">").toString();
        } else {
            string = "<NULL>";
        }
        return string;
    }
}

