/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.psi.css.impl.util.completion.AngleUserLookup;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyValueInsertHandler;
import com.intellij.psi.css.impl.util.completion.provider.ValueUnitCompletionVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssFontFamilyDescriptor;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.inspections.invalid.CssInvalidPropertyValueInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyValueCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        CssValueDescriptorVisitorImpl visitor;
        Collection descriptors;
        PsiElement parent;
        if (parameters == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement element = parameters.getPosition();
        PsiElement elementParent = element.getParent();
        boolean isInsideString = elementParent instanceof CssString;
        boolean isValueUnit = elementParent.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM;
        CssTermList cssTermList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)element, CssTermList.class);
        PsiElement psiElement = parent = cssTermList == null ? null : cssTermList.getParent();
        if (parent instanceof CssDeclaration) {
            descriptors = CssInvalidPropertyValueInspection.getFilteredPropertyDescriptors((CssDeclaration)parent);
        } else if (parent instanceof CssFunction) {
            descriptors = CssDescriptorsUtil.filterDescriptorsByContext((Collection)((CssFunction)parent).getDescriptors(), (PsiElement)element);
        } else {
            return;
        }
        CssValueDescriptorVisitorImpl cssValueDescriptorVisitorImpl = visitor = isValueUnit ? new ValueUnitCompletionVisitor(result) : new ValueDescriptorCompletionVisitor(result, element);
        if (!isValueUnit && CssPropertyValueCompletionProvider.isNotClassicDialectWithSingleAnyValueDescriptor(element, descriptors)) {
            ((ValueDescriptorCompletionVisitor)visitor).addOldSchoolLookupElements((CssPropertyDescriptor)descriptors.iterator().next());
            return;
        }
        for (CssValueOwnerDescriptor descriptor : descriptors) {
            ProgressManager.checkCanceled();
            CssValueDescriptorMapper mapper = new CssValueDescriptorMapper(cssTermList);
            mapper.mapValue(descriptor.getValueDescriptor());
            for (CssValueDescriptor valueDescriptor : mapper.getAllowableDescriptorsForCompletion()) {
                if (!valueDescriptor.isShowInCompletion() || isInsideString && !(valueDescriptor instanceof CssStringValue)) continue;
                valueDescriptor.accept((CssValueDescriptorVisitor)visitor);
            }
        }
    }

    private static boolean isNotClassicDialectWithSingleAnyValueDescriptor(@NotNull PsiElement element, @NotNull Collection<? extends CssValueOwnerDescriptor> descriptors) {
        CssValueOwnerDescriptor descriptor;
        if (element == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(4);
        }
        if (descriptors.size() == 1 && (descriptor = descriptors.iterator().next()) instanceof CssPropertyDescriptor && descriptor.getValueDescriptor() instanceof CssAnyValue) {
            CssDialect dialect = CssDialectMappings.getInstance(element.getProject()).getDefaultMapping(element.getContainingFile().getOriginalFile().getVirtualFile());
            return dialect != CssDialect.CLASSIC;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssPropertyValueCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotClassicDialectWithSingleAnyValueDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ValueDescriptorCompletionVisitor
    extends CssValueDescriptorVisitorImpl {
        @NotNull
        private final CompletionResultSet myCompletionResultSet;
        @NotNull
        private final PsiElement myContext;
        private final Set<String> myProcessedLookupStrings;

        public ValueDescriptorCompletionVisitor(@NotNull CompletionResultSet completionResultSet, @NotNull PsiElement context) {
            if (completionResultSet == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(1);
            }
            this.myProcessedLookupStrings = new THashSet();
            this.myCompletionResultSet = completionResultSet;
            this.myContext = context;
        }

        @Override
        public void visitNameValue(@NotNull CssNameValue nameValue) {
            String value;
            if (nameValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(2);
            }
            if ((value = nameValue.getValue()) == null) {
                return;
            }
            if (this.myProcessedLookupStrings.add(value)) {
                this.myCompletionResultSet.addElement((LookupElement)LookupElementBuilder.create((Object)nameValue, (String)value).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
            }
        }

        @Override
        public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
            String functionName;
            String lookupString;
            if (functionValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(3);
            }
            String string = lookupString = (functionName = functionValue.getFunctionName()).equals("url") ? functionName + "(\"\")" : functionName + "()";
            if (this.myProcessedLookupStrings.add(lookupString)) {
                this.myCompletionResultSet.addElement((LookupElement)LookupElementBuilder.create((Object)functionValue, (String)lookupString).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
            }
        }

        @Override
        public void visitStringValue(@NotNull CssStringValue stringValue) {
            String lookupString;
            String value;
            if (stringValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(4);
            }
            if ((value = stringValue.getValue()) == null) {
                return;
            }
            boolean isInsideString = this.myContext.getParent() instanceof CssString;
            String string = lookupString = isInsideString ? value : "\"" + value + "\"";
            if (this.myProcessedLookupStrings.add(lookupString)) {
                this.myCompletionResultSet.addElement((LookupElement)LookupElementBuilder.create((Object)stringValue, (String)lookupString).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
            }
        }

        @Override
        public void visitColorValue(@NotNull CssColorValue colorValue) {
            if (colorValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(5);
            }
            this.addOldSchoolLookupElements(new com.intellij.psi.css.impl.util.table.CssColorValue(colorValue.isAllColorKeywordsKnown()));
        }

        @Override
        public void visitLengthValue(@NotNull CssLengthValue lengthValue) {
            if (lengthValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(6);
            }
            this.addOldSchoolLookupElements(new CssLookupValue(new LengthUserLookup(), new CssTermType[0]));
        }

        @Override
        public void visitAngleValue(@NotNull CssAngleValue angleValue) {
            if (angleValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(7);
            }
            this.addOldSchoolLookupElements(new CssLookupValue(new AngleUserLookup(), new CssTermType[0]));
        }

        @Override
        public void visitInlineValue(@NotNull CssInlineValue inlineValue) {
            if (inlineValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(8);
            }
            if (inlineValue.getRefId().equals("font-family")) {
                this.addOldSchoolLookupElements(new CssFontFamilyDescriptor("font-family", CssPropertyInfo.EMPTY_ARRAY));
            }
        }

        private void addOldSchoolLookupElements(@NotNull CssPropertyDescriptor propertyDescriptor) {
            if (propertyDescriptor == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(9);
            }
            for (Object o : propertyDescriptor.getVariants(this.myContext)) {
                this.addOldSchoolLookupElement(o);
            }
        }

        private void addOldSchoolLookupElements(@NotNull CssPropertyValue oldSchoolPropertyValue) {
            if (oldSchoolPropertyValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(10);
            }
            this.addOldSchoolLookupElement(oldSchoolPropertyValue.getValue());
            for (CssPropertyValue dynamicVariant : oldSchoolPropertyValue.getDynamicVariants(this.myContext)) {
                this.addOldSchoolLookupElements(dynamicVariant);
            }
        }

        private void addOldSchoolLookupElement(@Nullable Object o) {
            LookupElement lookupElement = CssCompletionUtil.valueLookupElement(o);
            if (lookupElement != null && this.myProcessedLookupStrings.add(lookupElement.getLookupString())) {
                this.myCompletionResultSet.addElement(lookupElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionResultSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorValue";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lengthValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "angleValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlineValue";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyDescriptor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldSchoolPropertyValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssPropertyValueCompletionProvider$ValueDescriptorCompletionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNameValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFunctionValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStringValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitColorValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLengthValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAngleValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInlineValue";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOldSchoolLookupElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

