/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlLinkUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XhtmlFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.resolve.impl.XhtmlFileInfo");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    private final XmlFile myXhtmlFile;
    private final long myModificationStamp;
    private final Pair[] myPairs;
    private CssStylesheet[] myStylesheets = new CssStylesheet[0];
    private CssStylesheet[] myAllStylesheets = new CssStylesheet[0];
    @NonNls
    private String[] myReferencedStylesheetNames;
    private int myPreferredCssStylesheetIndex = -1;
    private final Set<CssStylesheet> myReferencedStylesheets;
    @NonNls
    public static final String DEFAULT_STYLESHEET_FILE_NAME = "css2default_.css";
    @NonNls
    private static final String _INTERNAL_DEFAULT_CSS_NAME = "css2default.css.txt";
    private boolean myUseAgentStylesheet;
    private CssStylesheet myPredefinedStylesheet;
    @NonNls
    private static final Pattern CSS_SUFFIX_PATTERN = Pattern.compile(".css(\\?.*)?$");
    @NonNls
    private static final String TEXT_CSS_TYPE = "text/css";

    XhtmlFileInfo(XmlFile xhtmlFile) {
        assert (xhtmlFile != null);
        this.myXhtmlFile = xhtmlFile;
        this.myModificationStamp = xhtmlFile.getModificationStamp();
        this.myReferencedStylesheets = new HashSet<CssStylesheet>(2);
        this.initStylesheets();
        this.myPairs = this.getPairs();
    }

    @Nullable
    private static CssStylesheet getPredefinedStylesheet(@NotNull Project project) {
        if (project == null) {
            XhtmlFileInfo.$$$reportNull$$$0(0);
        }
        return (CssStylesheet)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            String s;
            if (project == null) {
                XhtmlFileInfo.$$$reportNull$$$0(6);
            }
            CssStylesheet stylesheet = (s = XhtmlFileInfo.loadDefaultCssContent()) != null ? CssElementFactory.getInstance((Project)project).createStylesheet(s, (Language)CSSLanguage.INSTANCE) : null;
            return CachedValueProvider.Result.create((Object)stylesheet, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String loadDefaultCssContent() {
        InputStream stream = XhtmlFileInfo.class.getResourceAsStream(_INTERNAL_DEFAULT_CSS_NAME);
        if (stream == null) {
            LOG.error("Cannot open find internal default css file", new String[]{_INTERNAL_DEFAULT_CSS_NAME});
            return null;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        try {
            String string = FileUtil.loadTextAndClose((Reader)streamReader);
            return string;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                streamReader.close();
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private void initStylesheets() {
        PsiElement[] linkUrls;
        this.myPredefinedStylesheet = XhtmlFileInfo.getPredefinedStylesheet(this.myXhtmlFile.getProject());
        this.myReferencedStylesheets.clear();
        try {
            linkUrls = XhtmlFileInfo.gatherLinks(this.myXhtmlFile, false);
        }
        catch (PsiInvalidElementAccessException e) {
            VirtualFile vFile = this.myXhtmlFile.getVirtualFile();
            if (vFile != null) {
                LOG.error((Object)LogMessageEx.createEvent((String)"InvalidElementAccess", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)vFile)}));
            }
            throw e;
        }
        this.myStylesheets = this.getStylesheets(linkUrls, false);
        this.myReferencedStylesheetNames = new String[linkUrls.length];
        int nonQualifiedAlternateCount = 0;
        for (int i = 0; i < linkUrls.length; ++i) {
            boolean isAlternate;
            XmlTag tag = (XmlTag)linkUrls[i].getParent().getParent();
            String title = tag.getAttributeValue("title");
            String rel = tag.getAttributeValue("rel");
            boolean bl = isAlternate = rel != null && rel.contains("alternate");
            if (title == null && rel != null && isAlternate) {
                title = "alternate" + (++nonQualifiedAlternateCount != 1 ? String.valueOf(nonQualifiedAlternateCount) : "");
            }
            if (!isAlternate && title != null && this.myPreferredCssStylesheetIndex == -1) {
                this.myPreferredCssStylesheetIndex = i;
            }
            this.myReferencedStylesheetNames[i] = title == null ? "__$persistent$__" : title;
        }
        PsiElement[] allLinkUrls = XhtmlFileInfo.gatherLinks(this.myXhtmlFile, true);
        this.myAllStylesheets = this.getStylesheets(allLinkUrls, true);
    }

    public static PsiElement[] gatherLinks(XmlFile xhtmlFile, boolean allMedias) {
        ArrayList result = new ArrayList();
        HtmlLinkUtil.processLinks((XmlFile)xhtmlFile, xmlTag -> {
            XhtmlFileInfo.processLinkTag(xmlTag, result, allMedias);
            return true;
        });
        return PsiUtilCore.toPsiElementArray(result);
    }

    private CssStylesheet[] getStylesheets(@NotNull PsiElement[] linkElements, boolean allMedias) {
        if (linkElements == null) {
            XhtmlFileInfo.$$$reportNull$$$0(1);
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (PsiElement element : linkElements) {
            this.findOneStyleSheet(element, result, (PsiFile)this.myXhtmlFile, true, allMedias);
        }
        return (CssStylesheet[])ArrayUtil.toObjectArray((Collection)result, CssStylesheet.class);
    }

    private static void processLinkTag(@NotNull XmlTag tag, @NotNull List<PsiElement> result, boolean allMedias) {
        XmlAttributeValue valueElement;
        XmlAttribute attribute;
        if (tag == null) {
            XhtmlFileInfo.$$$reportNull$$$0(2);
        }
        if (result == null) {
            XhtmlFileInfo.$$$reportNull$$$0(3);
        }
        String type = tag.getAttributeValue("type");
        String href = tag.getAttributeValue("href");
        if (href == null) {
            return;
        }
        if (type == null && !CSS_SUFFIX_PATTERN.matcher(href).find()) {
            return;
        }
        String media = tag.getAttributeValue("media");
        HashSet mediaTypes = Sets.newHashSet((Iterable)COMMA_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)media).toUpperCase(Locale.US)));
        if ((type == null || TEXT_CSS_TYPE.equals(type)) && (allMedias || media == null || mediaTypes.contains(CssMediaType.SCREEN.toString()) || mediaTypes.contains(CssMediaType.ALL.toString())) && (attribute = tag.getAttribute("href")) != null && (valueElement = attribute.getValueElement()) != null) {
            result.add((PsiElement)valueElement);
        }
    }

    boolean isReferencedStyleSheet(CssStylesheet stylesheet) {
        return this.myReferencedStylesheets.contains(stylesheet);
    }

    @Nullable
    String getPreferredStylesheetName() {
        if (this.myPreferredCssStylesheetIndex == -1) {
            return null;
        }
        return this.myReferencedStylesheetNames[this.myPreferredCssStylesheetIndex];
    }

    public CssStylesheet[] getLinkStylesheets() {
        this.checkIfModified();
        return this.getLinkStylesheets(this.myUseAgentStylesheet, false);
    }

    public CssStylesheet[] getAllLinkStylesheets() {
        this.checkIfModified();
        return this.getLinkStylesheets(this.myUseAgentStylesheet, true);
    }

    private CssStylesheet[] getLinkStylesheets(boolean withAgentStylesheet, boolean allMedias) {
        CssStylesheet[] stylesheets;
        CssStylesheet[] cssStylesheetArray = stylesheets = allMedias ? this.myAllStylesheets : this.myStylesheets;
        if (!withAgentStylesheet || this.myPredefinedStylesheet == null) {
            return stylesheets;
        }
        ArrayList<CssStylesheet> result = new ArrayList<CssStylesheet>(Arrays.asList(stylesheets));
        result.add(0, this.myPredefinedStylesheet);
        return result.toArray(new CssStylesheet[result.size()]);
    }

    @NonNls
    String[] getReferencedStylesheetNames() {
        this.checkIfModified();
        return this.myReferencedStylesheetNames;
    }

    private void checkIfModified() {
        boolean modified = false;
        if (this.myModificationStamp != this.myXhtmlFile.getModificationStamp()) {
            modified = true;
        } else {
            for (Pair pair : this.myPairs) {
                if (pair.getModificationStamp() == pair.getFile().getModificationStamp()) continue;
                modified = true;
                break;
            }
        }
        if (modified) {
            this.initStylesheets();
        }
    }

    private void findOneStyleSheet(PsiElement linkUrl, Set<CssStylesheet> visited, PsiFile base, boolean referenced, boolean allMedias) {
        PsiFile[] psiFiles;
        StylesheetFile file = null;
        for (PsiFile psiFile : psiFiles = linkUrl instanceof CssImport ? ((CssImport)linkUrl).resolve() : CssResolveManager.getInstance().resolveFiles(linkUrl, base)) {
            if (!(psiFile instanceof StylesheetFile)) continue;
            file = (StylesheetFile)psiFile;
            break;
        }
        if (file == null) {
            return;
        }
        CssStylesheet stylesheet = file.getStylesheet();
        if (stylesheet == null || visited.contains(stylesheet)) {
            return;
        }
        if (referenced) {
            this.myReferencedStylesheets.add(stylesheet);
        }
        visited.add(stylesheet);
        for (CssImport anImport : stylesheet.getImports()) {
            if (!allMedias && !anImport.isScreen()) continue;
            this.findOneStyleSheet((PsiElement)anImport, visited, (PsiFile)file, false, allMedias);
        }
    }

    private Pair[] getPairs() {
        ArrayList<Pair> collection = new ArrayList<Pair>();
        for (CssStylesheet myStylesheet : this.myStylesheets) {
            PsiFile containingFile = myStylesheet.getContainingFile();
            collection.add(new Pair(containingFile, containingFile.getModificationStamp()));
        }
        return (Pair[])ArrayUtil.toObjectArray(collection, Pair.class);
    }

    public void setUseAgentStyleSheet(boolean useAgentStylesheet) {
        this.myUseAgentStylesheet = useAgentStylesheet;
    }

    @Nullable
    public static XhtmlFileInfo getInfo(@NotNull XmlFile file, boolean useAgentStylesheets) {
        XhtmlFileInfo info;
        if (file == null) {
            XhtmlFileInfo.$$$reportNull$$$0(4);
        }
        if ((info = (XhtmlFileInfo)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            CssStylesheet[] stylesheets;
            if (file == null) {
                XhtmlFileInfo.$$$reportNull$$$0(5);
            }
            XhtmlFileInfo result = new XhtmlFileInfo(file);
            HashSet dependencies = ContainerUtil.newHashSet((Object[])new Object[]{file});
            for (CssStylesheet stylesheet : stylesheets = result.getAllLinkStylesheets()) {
                dependencies.add(stylesheet.getContainingFile());
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
        })) != null) {
            info.setUseAgentStyleSheet(useAgentStylesheets);
        }
        return info;
    }

    public int getLinksCount() {
        return this.myStylesheets.length;
    }

    public int getAllLinksCount() {
        return this.myAllStylesheets.length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPredefinedStylesheet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getStylesheets";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processLinkTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getInfo$2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getPredefinedStylesheet$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Pair {
        private final PsiFile myFile;
        private final long myModificationStamp;

        private Pair(PsiFile file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
        }

        private PsiFile getFile() {
            return this.myFile;
        }

        private long getModificationStamp() {
            return this.myModificationStamp;
        }
    }
}

