/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class JSQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet QUOTE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.BACKQUOTE, JSTokenTypes.STRING_TEMPLATE_PART})});

    protected JSQuoteHandler(TokenSet tokenSet) {
        super(tokenSet);
    }

    public JSQuoteHandler() {
        super(QUOTE_TOKENS);
    }

    public TokenSet getConcatenatableStringTokenTypes() {
        return TokenSet.EMPTY;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JSQuoteHandler.$$$reportNull$$$0(0);
        }
        return JSTokenTypes.WHITE_SPACE == tokenType || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.STRING_LITERAL || JSTokenTypes.XML_TOKENS.contains(tokenType) || tokenType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL;
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.isOpeningQuote(iterator, offset);
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            return true;
        }
        if (iterator.getTokenType() == JSTokenTypes.BACKQUOTE && !iterator.atEnd()) {
            iterator.advance();
            boolean result = iterator.atEnd() || iterator.getTokenType() != JSTokenTypes.BACKQUOTE;
            iterator.retreat();
            return result;
        }
        return super.isClosingQuote(iterator, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/javascript/JSQuoteHandler", "isAppropriateElementTypeForLiteral"));
    }
}

