/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreModulesCatalog {
    private static final Logger LOG;
    private static final String FILE_NAME = "node-core-modules-catalog.json";
    public static final NodeJsCoreModulesCatalog INSTANCE;
    private final Set<String> myPublicAllCoreModules;
    private final Set<String> myPublicExcludedCoreModules;
    private final Set<String> myPrivateIncludedCoreModules;
    private final Map<String, String> myPublicReplacementMap;

    private NodeJsCoreModulesCatalog(@NotNull List<String> publicAllCoreModules, @NotNull List<String> publicExcludedCoreModules, @NotNull List<String> privateIncludedCoreModules, @NotNull Map<String, String> publicReplacementMap) {
        if (publicAllCoreModules == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(0);
        }
        if (publicExcludedCoreModules == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(1);
        }
        if (privateIncludedCoreModules == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(2);
        }
        if (publicReplacementMap == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(3);
        }
        this.myPublicAllCoreModules = ImmutableSet.copyOf(publicAllCoreModules);
        this.myPublicExcludedCoreModules = ImmutableSet.copyOf(publicExcludedCoreModules);
        this.myPrivateIncludedCoreModules = ImmutableSet.copyOf(privateIncludedCoreModules);
        this.myPublicReplacementMap = ImmutableMap.copyOf(publicReplacementMap);
    }

    @NotNull
    public ImmutableList<String> getPublicCoreModules() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myPublicAllCoreModules);
        if (immutableList == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public boolean isPublicCoreModule(@Nullable String name) {
        return this.myPublicAllCoreModules.contains(name);
    }

    public boolean isIncludedCoreModule(String name) {
        if (this.myPublicAllCoreModules.contains(name) && !this.myPublicExcludedCoreModules.contains(name)) {
            return true;
        }
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    public boolean isPublicExcludedCoreModule(String name) {
        return this.myPublicExcludedCoreModules.contains(name);
    }

    public boolean isPrivateIncludedCoreModule(String name) {
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    @Nullable
    public String getPublicReplacementName(@NotNull String path) {
        if (path == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(5);
        }
        return this.myPublicReplacementMap.get(path);
    }

    @NotNull
    private static NodeJsCoreModulesCatalog parse() throws IOException {
        InputStream stream = NodeJsCoreModulesCatalog.class.getResourceAsStream(FILE_NAME);
        if (stream == null) {
            throw new IOException("NodeJS plugin installation is possibly broken. Cannot find node-core-modules-catalog.json");
        }
        NodeJsCoreModulesCatalog nodeJsCoreModulesCatalog = NodeJsCoreModulesCatalog.doParse(stream);
        NodeJsCoreModulesCatalog nodeJsCoreModulesCatalog2 = nodeJsCoreModulesCatalog;
        if (nodeJsCoreModulesCatalog2 == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(6);
        }
        return nodeJsCoreModulesCatalog2;
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static NodeJsCoreModulesCatalog doParse(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(7);
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
        reader.beginObject();
        List publicAllNames = Collections.emptyList();
        List publicExcludedNames = Collections.emptyList();
        List privateIncludedNames = Collections.emptyList();
        HashMap publicReplacement = Collections.emptyMap();
        while (reader.hasNext()) {
            String type = reader.nextName();
            if ("public-all".equals(type)) {
                publicAllNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if ("public-excluded".equals(type)) {
                publicExcludedNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if ("private-included".equals(type)) {
                privateIncludedNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if (!"public-replacement".equals(type)) continue;
            Map map = JsonUtil.nextMap((JsonReader)reader);
            publicReplacement = ContainerUtil.newHashMap();
            for (Map.Entry entry : map.entrySet()) {
                publicReplacement.put(entry.getKey(), (String)entry.getValue());
            }
        }
        reader.endObject();
        NodeJsCoreModulesCatalog nodeJsCoreModulesCatalog = new NodeJsCoreModulesCatalog(publicAllNames, publicExcludedNames, privateIncludedNames, publicReplacement);
        if (nodeJsCoreModulesCatalog == null) {
            NodeJsCoreModulesCatalog.$$$reportNull$$$0(8);
        }
        return nodeJsCoreModulesCatalog;
    }

    static {
        NodeJsCoreModulesCatalog catalog;
        LOG = Logger.getInstance(NodeJsCoreModulesCatalog.class);
        try {
            catalog = NodeJsCoreModulesCatalog.parse();
        }
        catch (IOException e) {
            LOG.error("Failed to list core modules", (Throwable)e);
            List<String> empty = Collections.emptyList();
            catalog = new NodeJsCoreModulesCatalog(empty, empty, empty, Collections.emptyMap());
        }
        INSTANCE = catalog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicAllCoreModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicExcludedCoreModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateIncludedCoreModules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicReplacementMap";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicCoreModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublicReplacementName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

