/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        JSClass containingClass;
        PsiElement parent = context.getParent();
        if (ES6CompletionKeywordsContributor.addFromKeyword(consumer, parent)) {
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
        if (ES6PsiUtil.isAsyncContext(function)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "await");
        }
        if (function != null && function.isGenerator()) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "yield");
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement grandParentParent = grandParent != null ? grandParent.getParent() : null;
        boolean isModuleContext = false;
        if (parent instanceof JSReferenceExpression && grandParent instanceof JSExpressionStatement && (grandParentParent instanceof JSFile || grandParentParent instanceof TypeScriptModule || grandParentParent instanceof JSEmbeddedContent)) {
            PsiElement prevPrevSibling;
            PsiElement prevSibling = JSPsiImplUtils.findPrevCodeElement(grandParent);
            if (prevSibling instanceof PsiErrorElement && JSBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription()) && (prevPrevSibling = JSPsiImplUtils.findPrevCodeElement(prevSibling)) instanceof JSAttributeList && ((JSAttributeList)prevPrevSibling).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                this.appendKeywordsAfterExport(consumer);
                return false;
            }
            isModuleContext = true;
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "import", "export");
        }
        if (!isModuleContext && DialectDetector.isES6(context)) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "import()");
        }
        if (parent instanceof JSVariable && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)context).SPACE_BEFORE_METHOD_PARENTHESES, "constructor");
            consumer.consume(JSLookupPriority.SMART_PRIORITY, true, "static");
            return false;
        }
        JSPsiElementBase parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) != null && parentFunction.getJSContext() != JSContext.STATIC && !containingClass.isInterface() && containingClass.getExtendsList() != null && !(grandParent instanceof ES6Property)) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, false, "super");
        }
        return super.process(consumer, context);
    }

    private static boolean addFromKeyword(KeywordCompletionConsumer consumer, PsiElement parent) {
        PsiElement prevSibling;
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSExpressionStatement && (prevSibling = grandParent.getPrevSibling()) instanceof PsiWhiteSpace && prevSibling.getPrevSibling() instanceof ES6ImportDeclaration && prevSibling.getPrevSibling().getNode().findChildByType(FILE_REFERENCES) == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "from");
            return true;
        }
        return false;
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        super.appendSpecificKeywords(consumer);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class", "extends", "private", "public", "static", "yield", "async", "await", "of");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "constructor");
    }

    @Override
    public void appendExpressionContextKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        super.appendExpressionContextKeywords(consumer);
        consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "yield", "await");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class");
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "class", "var", "const", "let", "function", "default");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "consumer";
        objectArray2[1] = "com/intellij/lang/javascript/completion/ES6CompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExpressionContextKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

