/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormatterUtil {
    private JSFormatterUtil() {
    }

    public static boolean isInlineEndOfLineComment(@NotNull ASTNode node) {
        if (node == null) {
            JSFormatterUtil.$$$reportNull$$$0(0);
        }
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            ASTNode prev = node.getTreePrev();
            return !(prev.getPsi() instanceof PsiWhiteSpace) || !prev.textContains('\n');
        }
        return false;
    }

    public static boolean isEnterAtNewArgument(@NotNull FormattingMode formattingMode, @Nullable ASTNode child) {
        if (formattingMode == null) {
            JSFormatterUtil.$$$reportNull$$$0(1);
        }
        if (formattingMode != FormattingMode.ADJUST_INDENT_ON_ENTER || child == null) {
            return false;
        }
        return child.getElementType() != JSTokenTypes.LPAR && (child.getElementType() != JSTokenTypes.RPAR || FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.COMMA, (IElementType[])new IElementType[]{TokenType.ERROR_ELEMENT}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/JSFormatterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlineEndOfLineComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnterAtNewArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

