/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.fixes.AddSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateConstructorFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<JSClass> myTargetClassPointer;
    private final String myName;

    public ES6CreateConstructorFix(JSCallExpression callExpression, JSClass jsClass) {
        super((PsiElement)callExpression);
        this.myTargetClassPointer = SmartPointerManager.getInstance((Project)jsClass.getProject()).createSmartPsiElementPointer((PsiElement)jsClass);
        this.myName = JSBundle.message((String)"javascript.create.constructor.intention.name", (Object[])new Object[]{jsClass.getName()});
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Editor targetEditor;
        if (project == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(3);
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, JSCallExpression.class, (boolean)false);
        JSClass jsClass = (JSClass)this.myTargetClassPointer.getElement();
        if (callExpression == null || jsClass == null) {
            return;
        }
        Editor editor2 = targetEditor = jsClass.getContainingFile() != file ? BaseCreateFix.getEditor(project, jsClass.getContainingFile()) : editor;
        if (targetEditor == null) {
            return;
        }
        ES6CreateConstructorFix.generateConstructor(jsClass, callExpression.getArgumentList(), targetEditor);
    }

    public static void generateConstructor(@NotNull JSClass targetClass, @Nullable JSArgumentList argumentList, @NotNull Editor targetEditor) {
        if (targetClass == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(4);
        }
        if (targetEditor == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(5);
        }
        PsiFile targetFile = targetClass.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(targetFile)) {
            return;
        }
        Project project = targetClass.getProject();
        ASTNode lbrace = targetClass.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (lbrace == null) {
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        BaseCreateFix.InsertPlaceInfo insertPlaceInfo = new BaseCreateFix.InsertPlaceInfo(lbrace.getTreeNext().getPsi(), targetFile, true, false);
        if (insertPlaceInfo.addNewLineBefore) {
            template.addTextSegment("\n");
        }
        template.addTextSegment("constructor");
        template.addTextSegment("(");
        CreateJSFunctionIntentionAction.addParameters(template, argumentList, (PsiElement)argumentList, targetFile);
        template.addTextSegment(")");
        template.addTextSegment("{\n");
        if (!ArrayUtil.isEmpty((Object[])targetClass.getSuperClasses())) {
            JSFunction superConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor(targetClass);
            AddSuperInvocationFix.addToTemplate(template, (PsiElement)targetClass, superConstructor);
        }
        template.addEndVariable();
        template.addTextSegment("\n}");
        if (insertPlaceInfo.toInsertNewLineAfter) {
            template.addTextSegment("\n");
        }
        int offset = insertPlaceInfo.anchor.getTextRange().getStartOffset();
        BaseCreateFix.navigate(project, targetEditor, offset, targetFile.getVirtualFile());
        templateManager.startTemplate(targetEditor, template);
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            ES6CreateConstructorFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEditor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6CreateConstructorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6CreateConstructorFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructor";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

