/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ChangeImportIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Nullable
    public static ES6ChangeImportIntention create(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        Collection psiElements = clause.resolveReferencedElements();
        if (psiElements.size() != 1 || !(ContainerUtil.getFirstItem((Collection)psiElements) instanceof JSFile)) {
            return null;
        }
        return new ES6ChangeImportIntention();
    }

    @NotNull
    public static List<JSModuleNameInfo> getModuleInfos(@NotNull ES6ImportDeclaration declaration, @NotNull ES6FromClause clause, Collection<JSQualifiedNamedElement> elements, boolean stopIfMoreThanOne) {
        if (declaration == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(1);
        }
        if (clause == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSQualifiedNamedElement firstItem = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(elements);
        if (firstItem == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ChangeImportIntention.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap checkedFiles = ContainerUtil.newHashMap();
        String importText = StringUtil.unquoteString((String)StringUtil.notNullize((String)clause.getReferenceText()));
        Processor processor = info -> {
            if (declaration == null) {
                ES6ChangeImportIntention.$$$reportNull$$$0(16);
            }
            if (!info.isValid()) {
                return true;
            }
            if (StringUtil.equals((CharSequence)importText, (CharSequence)info.getModuleName())) {
                return true;
            }
            boolean allIncluded = true;
            VirtualFile resolvedFile = info.getResolvedFile();
            Boolean value = (Boolean)checkedFiles.get(resolvedFile);
            if (value == null) {
                for (JSQualifiedNamedElement element : elements) {
                    if (element == firstItem || ES6CreateImportUtil.checkSymbolInFile(element.getProject(), resolvedFile, (PsiElement)element, (PsiElement)declaration.getContainingFile())) continue;
                    allIncluded = false;
                }
                checkedFiles.put(resolvedFile, allIncluded);
            } else if (Boolean.FALSE.equals(value)) {
                return true;
            }
            if (allIncluded) {
                infos.add(info);
            }
            return !stopIfMoreThanOne || infos.size() <= 1;
        };
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)firstItem);
        if (originalFile == null) {
            ArrayList arrayList = infos;
            if (arrayList == null) {
                ES6ChangeImportIntention.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder((PsiElement)declaration, (PsiElement)firstItem, originalFile);
        builder.processModuleNames((Processor<JSModuleNameInfo>)processor);
        ArrayList arrayList = infos;
        if (arrayList == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static Collection<JSQualifiedNamedElement> getResolvedElements(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        ES6ImportSpecifier[] specifiers;
        if (declaration == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet resolvedElements = ContainerUtil.newHashSet();
        for (ES6ImportSpecifier specifier : specifiers = declaration.getImportSpecifiers()) {
            ResolveResult[] results;
            for (ResolveResult result : results = specifier.multiResolve(false)) {
                PsiElement element;
                if (!result.isValidResult() || !((element = result.getElement()) instanceof JSQualifiedNamedElement)) continue;
                resolvedElements.add((JSQualifiedNamedElement)element);
            }
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            Collection elements = binding.findReferencedElements().stream().filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList());
            resolvedElements.addAll(elements);
        }
        return resolvedElements;
    }

    public ES6ChangeImportIntention() {
        this.setText(JSBundle.message((String)"ts.change.import.action.many.title", (Object[])new Object[0]));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ES6ImportDeclaration importDeclaration;
        if (project == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(9);
        }
        if ((importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class)) == null) {
            return;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        Collection<JSQualifiedNamedElement> elements = ES6ChangeImportIntention.getResolvedElements(importDeclaration);
        List<JSModuleNameInfo> infos = ES6ChangeImportIntention.getModuleInfos(importDeclaration, clause, elements, false);
        if (infos.isEmpty()) {
            return;
        }
        if (infos.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            JSModuleNameInfo info = infos.get(0);
            WriteAction.run(() -> {
                if (project == null) {
                    ES6ChangeImportIntention.$$$reportNull$$$0(15);
                }
                ES6ReplaceImportFromClauseFix.changeImportFromText(project, clause, info.getModuleName());
            });
        } else {
            JBList list = new JBList(infos);
            list.setFont(EditorUtil.getEditorFont());
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
            builder.setTitle(JSBundle.message((String)"ts.change.import.action.dialog.title", (Object[])new Object[0]));
            JBPopup popup = builder.setItemChoosenCallback(() -> ES6ChangeImportIntention.lambda$invoke$6((JList)list, project, clause)).createPopup();
            builder.getScrollPane().setBorder(null);
            builder.getScrollPane().setViewportBorder(null);
            NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
            popup.showInBestPositionFor(editor);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(11);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class);
        if (importDeclaration == null) {
            return false;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection<JSQualifiedNamedElement> elements = ES6ChangeImportIntention.getResolvedElements(importDeclaration);
        List<JSModuleNameInfo> infos = ES6ChangeImportIntention.getModuleInfos(importDeclaration, clause, elements, true);
        if (infos.size() == 0) {
            return false;
        }
        if (infos.size() == 1) {
            this.setText(JSBundle.message((String)"ts.change.import.action.one.title", (Object[])new Object[]{infos.get(0).toString()}));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$invoke$6(JList list, @NotNull Project project, ES6FromClause clause) {
        JSModuleNameInfo info;
        if (project == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(12);
        }
        if ((info = (JSModuleNameInfo)list.getSelectedValue()) != null) {
            Runnable toRun = () -> {
                if (project == null) {
                    ES6ChangeImportIntention.$$$reportNull$$$0(13);
                }
                WriteAction.run(() -> {
                    if (project == null) {
                        ES6ChangeImportIntention.$$$reportNull$$$0(14);
                    }
                    ES6ReplaceImportFromClauseFix.changeImportFromText(project, clause, info.getModuleName());
                });
            };
            CommandProcessor.getInstance().executeCommand(project, toRun, JSBundle.message((String)"ts.change.import.action.command", (Object[])new Object[0]), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ChangeImportIntention";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ChangeImportIntention";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfos";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModuleInfos$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

