/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.AnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrowFunctionToShorthandArrowFunctionIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSArrowFunctionToShorthandArrowFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.shorthand.arrow.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        boolean anonymousArrow = arrowFunction != null && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction);
        return anonymousArrow && JSArrowFunctionToShorthandArrowFunctionIntention.getSingleBodyExpression(arrowFunction) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSElement replaced;
        JSFunctionExpression arrowFunction;
        boolean anonymousArrow;
        if (project == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(3);
        }
        boolean bl = anonymousArrow = (arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element)) != null && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction);
        if (!anonymousArrow) {
            return;
        }
        JSElement expression = JSArrowFunctionToShorthandArrowFunctionIntention.getSingleBodyExpression(arrowFunction);
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class);
        if (expression == null || block == null) {
            return;
        }
        if (expression instanceof JSObjectLiteralExpression) {
            JSVarStatement varStatement = (JSVarStatement)JSChangeUtil.createStatementFromText(project, "var a = () => ({});", DialectDetector.languageDialectOfElement(element)).getPsi();
            JSFunctionExpression function = (JSFunctionExpression)ObjectUtils.tryCast((Object)varStatement.getVariables()[0].getInitializer(), JSFunctionExpression.class);
            assert (function != null);
            JSParenthesizedExpression parenthesis = (JSParenthesizedExpression)PsiTreeUtil.findChildOfType((PsiElement)function, JSParenthesizedExpression.class);
            assert (parenthesis != null);
            parenthesis.getInnerExpression().replace((PsiElement)expression);
            replaced = JSChangeUtil.replaceElement((JSElement)block, (JSElement)parenthesis);
        } else {
            replaced = JSChangeUtil.replaceElement((JSElement)block, expression);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)replaced.getContainingFile(), replaced.getTextRange().getStartOffset(), replaced.getTextRange().getEndOffset());
    }

    @Nullable
    private static JSElement getSingleBodyExpression(@NotNull JSFunctionExpression function) {
        PsiElement statement;
        JSBlockStatement block;
        if (function == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(4);
        }
        if ((block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class)) == null) {
            return null;
        }
        List<PsiElement> blockElements = JSArrowFunctionToShorthandArrowFunctionIntention.getStatementsAndComments(block);
        PsiElement psiElement = statement = blockElements.size() == 1 ? blockElements.get(0) : null;
        while (statement instanceof JSBlockStatement) {
            List<PsiElement> elements = JSArrowFunctionToShorthandArrowFunctionIntention.getStatementsAndComments((JSBlockStatement)statement);
            statement = elements.size() == 1 ? elements.get(0) : null;
        }
        if (statement == null) {
            return null;
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)statement).getExpression();
        }
        if (statement instanceof JSExpressionStatement) {
            return JSArrowFunctionToShorthandArrowFunctionIntention.checkStatement((JSExpressionStatement)statement) ? ((JSExpressionStatement)statement).getExpression() : null;
        }
        return null;
    }

    private static List<PsiElement> getStatementsAndComments(@NotNull JSBlockStatement block) {
        if (block == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(5);
        }
        return ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isStatementOrComment(element));
    }

    static boolean checkStatement(@NotNull JSExpressionStatement statement) {
        if (statement == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(6);
        }
        return !(statement.getExpression() instanceof JSCommaExpression);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.shorthand.arrow.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSArrowFunctionToShorthandArrowFunctionIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSingleBodyExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsAndComments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkStatement";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

