/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class JSConvertToForEachIntention
extends JavaScriptIntention {
    private static final String ELEMENT_NAME = "element";
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    public static final Pair<String, PsiElement> NULL_PAIR = Pair.create(null, null);
    private String varName;

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSStatement parent;
        if (project == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(1);
        }
        if (!((parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class})) instanceof JSForInStatement)) {
            return false;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        if (forInStatement.isForEach()) {
            return false;
        }
        this.varName = (String)JSConvertToForEachIntention.getForInVarName(forInStatement).getFirst();
        if (this.varName == null) {
            return false;
        }
        final JSExpression collectionExpression = forInStatement.getCollectionExpression();
        if (collectionExpression == null) {
            return false;
        }
        final Ref allUsagesArePropertyAccess = Ref.create((Object)Boolean.TRUE);
        JSStatement body = forInStatement.getBody();
        if (body == null) {
            return false;
        }
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() != null || !JSConvertToForEachIntention.this.varName.equals(node.getReferenceName())) {
                    return;
                }
                PsiElement referenceParent = node.getParent();
                if (!(referenceParent instanceof JSIndexedPropertyAccessExpression)) {
                    allUsagesArePropertyAccess.set((Object)Boolean.FALSE);
                    return;
                }
                JSExpression qualifier = ((JSIndexedPropertyAccessExpression)referenceParent).getQualifier();
                if (qualifier != null && collectionExpression.equals(qualifier)) {
                    allUsagesArePropertyAccess.set((Object)Boolean.FALSE);
                }
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention$1", "visitJSFunctionDeclaration"));
            }
        }.visitElement((PsiElement)body);
        return (Boolean)allUsagesArePropertyAccess.get();
    }

    @NotNull
    public static Pair<String, PsiElement> getForInVarName(@NotNull JSForInStatement forInStatement) {
        JSVarStatement varStatement;
        if (forInStatement == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(2);
        }
        if ((varStatement = forInStatement.getDeclarationStatement()) != null && varStatement.getVariables().length == 1 && varStatement.equals(varStatement.getVariables()[0].getParent())) {
            Pair pair = Pair.create((Object)varStatement.getVariables()[0].getName(), (Object)varStatement.getVariables()[0]);
            if (pair == null) {
                JSConvertToForEachIntention.$$$reportNull$$$0(3);
            }
            return pair;
        }
        JSExpression variableExpression = forInStatement.getVariableExpression();
        if (variableExpression instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)variableExpression).getExpression();
            if (!(expression instanceof JSReferenceExpression)) {
                Pair<String, PsiElement> pair = NULL_PAIR;
                if (pair == null) {
                    JSConvertToForEachIntention.$$$reportNull$$$0(4);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)expression.getText(), (Object)expression);
            if (pair == null) {
                JSConvertToForEachIntention.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (!(variableExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)variableExpression).getQualifier() != null) {
            Pair<String, PsiElement> pair = NULL_PAIR;
            if (pair == null) {
                JSConvertToForEachIntention.$$$reportNull$$$0(6);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)variableExpression.getText(), (Object)variableExpression);
        if (pair == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(7);
        }
        return pair;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSStatement parent;
        if (project == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(9);
        }
        if (!((parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class})) instanceof JSForInStatement)) {
            return;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        final TIntArrayList occurrences = new TIntArrayList();
        final StringBuilder stringBuilder = new StringBuilder(forInStatement.getCollectionExpression().getText());
        stringBuilder.append(".forEach(function(");
        occurrences.add(stringBuilder.length() + 2);
        stringBuilder.append(ELEMENT_NAME).append(") ");
        final JSStatement body = forInStatement.getBody();
        final Ref processedBody = Ref.create((Object)0);
        final String bodyText = body.getText();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() != null || !JSConvertToForEachIntention.this.varName.equals(node.getReferenceName())) {
                    return;
                }
                PsiElement referenceParent = node.getParent();
                assert (referenceParent instanceof JSIndexedPropertyAccessExpression);
                stringBuilder.append(bodyText.substring((Integer)processedBody.get(), referenceParent.getTextRange().getStartOffset() - body.getTextRange().getStartOffset()));
                occurrences.add(stringBuilder.length() + 2);
                stringBuilder.append(JSConvertToForEachIntention.ELEMENT_NAME);
                processedBody.set((Object)(referenceParent.getTextRange().getEndOffset() - body.getTextRange().getStartOffset()));
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention$2", "visitJSFunctionDeclaration"));
            }
        }.visitElement((PsiElement)body);
        stringBuilder.append(bodyText.substring((Integer)processedBody.get(), bodyText.length()));
        stringBuilder.append(");\n");
        PsiElement forEachOrphan = JSChangeUtil.createStatementFromText(project, stringBuilder.toString(), JSUtils.getDialect(element.getContainingFile())).getPsi();
        PsiElement forEach = forInStatement.replace(forEachOrphan);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(forEach.getTextOffset());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(forEach);
        PsiElement at = forEach.findElementAt(occurrences.get(0));
        builder.replaceElement(at, ELEMENT_NAME, (Expression)new ConstantNode(ELEMENT_NAME), true);
        for (int i = 1; i < occurrences.size(); ++i) {
            builder.replaceElement(forEach.findElementAt(occurrences.get(i) + 1), OTHER_VARIABLE_NAME, ELEMENT_NAME, false);
        }
        Template template = builder.buildInlineTemplate();
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.foreach.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.to.foreach.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_NAME;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getForInVarName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getForInVarName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

