/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.google.gson.JsonObject;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ESLintBasedLanguageService<TStoredState extends JSNpmLinterState<TStoredState>>
extends JSLanguageServiceBase
implements EslintLanguageServiceClient {
    public ESLintBasedLanguageService(@NotNull Project project) {
        if (project == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config2, @Nullable String content, String extraOptions) {
        if (StringUtil.isEmptyOrSpaces((String)content) || virtualFile == null) {
            return null;
        }
        String configPath = config2 == null ? null : JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(config2);
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        if (path == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture((Object)Pair.create((Object)JSLanguageServiceUtil.getLanguageServiceCreationError(this), Collections.emptyList()));
        }
        ESLintGetErrorsCommand command = new ESLintGetErrorsCommand(path, configPath, StringUtil.notNullize((String)content), extraOptions, ESLintBasedLanguageService.getIgnoreFilePath(virtualFile));
        return process.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @Override
    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlightAndFix(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config2, String extraOptions) {
        if (virtualFile == null) {
            return null;
        }
        String configPath = config2 == null ? null : JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(config2);
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        if (path == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture((Object)Pair.create((Object)JSLanguageServiceUtil.getLanguageServiceCreationError(this), Collections.emptyList()));
        }
        ESLintFixErrorsCommand command = new ESLintFixErrorsCommand(path, configPath, extraOptions, ESLintBasedLanguageService.getIgnoreFilePath(virtualFile));
        return process.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @NotNull
    protected abstract Class<? extends JSLinterConfiguration<TStoredState>> getConfigurationClass();

    protected abstract void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState var1, @NotNull TStoredState var2);

    @NotNull
    private static JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> createHighlightProcessor() {
        JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            String languageServiceError = JsonUtil.getChildAsString((JsonObject)answer.getElement(), (String)"error");
            if (languageServiceError != null) {
                return Pair.create((Object)languageServiceError, Collections.emptyList());
            }
            ESLintJsonProblemsParser parser = ESLintJsonProblemsParser.parse(answer.getElement());
            return Pair.create((Object)parser.getFileLevelError(), parser.getErrors());
        };
        if (jSLanguageServiceCommandProcessor == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(1);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        return new JSLanguageServiceQueueImpl(this.myProject, new Protocol(this.myProject, Consumer.EMPTY_CONSUMER), this.myProcessConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("ESLint" == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(2);
        }
        return "ESLint";
    }

    @Override
    protected boolean needInitToolWindow() {
        return false;
    }

    @NotNull
    private ExtendedLinterState<TStoredState> getExtendedState() {
        ExtendedLinterState<TStoredState> extendedLinterState = JSLinterConfiguration.getInstance(this.myProject, this.getConfigurationClass()).getExtendedState();
        if (extendedLinterState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(3);
        }
        return extendedLinterState;
    }

    @Nullable
    private static String getIgnoreFilePath(@NotNull VirtualFile virtualFile) {
        VirtualFile eslintIgnoreFile;
        if (virtualFile == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(4);
        }
        return (eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(virtualFile, ".eslintignore")) == null ? null : FileUtil.toSystemDependentName((String)eslintIgnoreFile.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull Project project, Consumer<?> readyConsumer) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(0);
            }
            if (readyConsumer == null) {
                Protocol.$$$reportNull$$$0(1);
            }
            super(project, readyConsumer);
        }

        public void dispose() {
        }

        @Override
        protected String getWorkingDirectory() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            return protocolState.eslintPackagePath;
        }

        @Override
        @Nullable
        protected String getNodeInterpreter() {
            ExtendedLinterState extendedState = ESLintBasedLanguageService.this.getExtendedState();
            return JSLanguageServiceUtil.getInterpreterPathIfValid(((JSNpmLinterState)extendedState.getState()).getInterpreterRef().resolve(this.myProject));
        }

        @Override
        protected JSLanguageServiceInitialState createState() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            protocolState.pluginName = "ESLint";
            File service = new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint/bin/eslint-plugin-provider.js");
            if (!service.exists()) {
                JSLanguageServiceQueue.LOGGER.info("ESLint plugin not found");
            }
            protocolState.pluginPath = service.getAbsolutePath();
            return protocolState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "readyConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

