/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;

public enum JSNamedElementKind {
    PARAMETER("javascript.parameter.kind"),
    LOCAL_VAR("javascript.local.variable.kind"),
    VAR("javascript.variable.kind"),
    FIELD("javascript.field.kind"),
    CONSTANT("javascript.constant.kind"),
    METHOD("javascript.method.kind"),
    CLASS("javascript.class.kind"),
    INTERFACE("javascript.interface.kind"),
    DEFINITION("javascript.definition.kind"),
    PROPERTY("javascript.property.kind"),
    NAMESPACE("javascript.namespace.kind"),
    FUNCTION("javascript.function.kind"),
    MODULE("javascript.module.kind"),
    ES6_BINDING("javascript.es6.binding.kind"),
    ES6_SPECIFIER("javascript.es6.specifier.kind"),
    ES6_IMPORT("javascript.es6.import.kind"),
    ES6_EXPORT_SPECIFIER("javascript.es6.exported.element"),
    ES6_DEFAULT_EXPORT("javascript.es6.export.default"),
    UNKNOWN("javascript.kind.unknown");

    private String myHumanReadableKey;

    private JSNamedElementKind(String humanReadableKey) {
        this.myHumanReadableKey = humanReadableKey;
    }

    @NonNls
    public String humanReadableKey() {
        return this.myHumanReadableKey;
    }

    public static JSNamedElementKind kind(PsiElement element, boolean isLocal) {
        JSNamedElementKind kind = JSNamedElementKind.kind(element);
        if (VAR.equals((Object)kind) || LOCAL_VAR.equals((Object)kind)) {
            return isLocal ? LOCAL_VAR : VAR;
        }
        return kind;
    }

    public static JSNamedElementKind kind(PsiElement element) {
        JSNamedElementKind res = UNKNOWN;
        PsiElement parent = JSResolveUtil.findParent(element);
        boolean clazzMember = parent instanceof JSClass;
        if (element instanceof JSVariable) {
            res = element instanceof JSParameter ? PARAMETER : (((JSVariable)element).isConst() ? CONSTANT : (clazzMember ? FIELD : (parent instanceof JSPackageStatement || ActionScriptResolveUtil.isFileLocalSymbol(element) ? VAR : LOCAL_VAR)));
        } else if (element instanceof JSFunction) {
            res = clazzMember ? METHOD : FUNCTION;
        } else if (element instanceof JSClass) {
            res = ((JSClass)element).isInterface() ? INTERFACE : CLASS;
        } else if (element instanceof JSNamespaceDeclaration) {
            res = NAMESPACE;
        } else if (element instanceof JSProperty || element instanceof TypeScriptPropertySignature) {
            res = PROPERTY;
        } else if (element instanceof JSDefinitionExpression) {
            res = DEFINITION;
        } else if (element instanceof TypeScriptModule) {
            res = MODULE;
        } else if (element.getParent() instanceof ES6ExportDefaultAssignment || element instanceof ES6ExportDefaultAssignment) {
            res = ES6_DEFAULT_EXPORT;
        } else if (element instanceof ES6ExportSpecifier) {
            res = ES6_EXPORT_SPECIFIER;
        }
        return res;
    }
}

