/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSQualifiedItemProcessor,
JSModuleElementsProcessor {
    private final boolean myEcma;
    private final boolean myTypeScript;
    public TypeResolveState resolved = TypeResolveState.Unknown;

    public QualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink);
        DialectOptionHolder holder = DialectDetector.dialectOfFile(containingFile);
        this.myEcma = holder != null && holder.isECMA4;
        this.myTypeScript = holder != null && holder.isTypeScript;
        this.setToProcessHierarchy(true);
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (type instanceof JSRecordType) {
            this.processRecordTypeImpl((JSRecordType)type);
            if (this.myTypeScript && type.getSource().isStrict()) {
                this.resolved = TypeResolveState.Resolved;
            }
            return;
        }
        if (evaluateContext.ensureProcessed(type, evaluateContext)) {
            return;
        }
        if (!JSTypeUtils.processExpandedType(this, type, evaluateContext, source)) {
            return;
        }
        this.processActionScriptClass(type, evaluateContext, source);
    }

    private void processActionScriptClass(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        PsiElement clazz;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (!this.myEcma && !(source instanceof XmlBackedJSClass)) {
            return;
        }
        String typeString = JSTypeUtils.getQualifiedNameMatchingType(type, true);
        if (type instanceof JSAnyType || typeString == null) {
            return;
        }
        PsiElement placeParent = this.place.getParent();
        boolean setTypeContext = placeParent instanceof JSReferenceListMember;
        PsiElement psiElement = clazz = source != null && (source instanceof JSClass || source instanceof XmlFile) ? source : JSClassResolver.findClassFromNamespace(typeString, this.place);
        if (clazz instanceof JSQualifiedNamedElement && this.needProcessTypeMembers(source, clazz)) {
            PsiElement typeSource = evaluateContext.getSource();
            AccessibilityProcessingHandler.processWithStatic(this, false, (Producer<Boolean>)((Producer)() -> {
                if (type == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(34);
                }
                if (evaluateContext == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(35);
                }
                this.addTypeFromClass(type, evaluateContext, typeString, typeSource, setTypeContext, (JSQualifiedNamedElement)clazz);
                return true;
            }));
        }
        if (type instanceof JSObjectType) {
            this.resolved = TypeResolveState.Unknown;
        } else if ((clazz == null || !(clazz instanceof JSQualifiedNamedElement)) && type.getSource().isStrict()) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    @Override
    public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        JSType type;
        if (namespace == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if ((type = BaseJSSymbolProcessor.namespaceAsType((JSNamespace)namespace, source)) != null) {
            this.process(type, evaluateContext, source);
        }
    }

    @Override
    public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        if (!QualifiedItemProcessor.processResolvedElement(element, evaluateContext, this, this.place)) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    public static boolean processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext, @NotNull JSResolveProcessor processor, @NotNull PsiElement place) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        if (place == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                value = ((JsonFile)element).getTopLevelValue();
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                } else {
                    List list = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
                return false;
            }
        } else if (element instanceof JSFile) {
            JSModuleElementsProcessor moduleElementsProcessor;
            JSModuleElementsProcessor jSModuleElementsProcessor = moduleElementsProcessor = processor instanceof JSModuleElementsProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor);
            if (!ES6PsiUtil.processExportDeclarationInScope((JSElement)((JSFile)element), moduleElementsProcessor, evaluateContext, ResolveState.initial(), null, place, null)) {
                return false;
            }
        } else {
            if (element instanceof StylesheetFile) {
                CssStylesheet stylesheet = ((StylesheetFile)element).getStylesheet();
                if (stylesheet != null) {
                    QualifiedItemProcessor.processCssClasses(stylesheet, processor);
                }
                return false;
            }
            if (element instanceof ES6ImportedBinding) {
                Collection referencedFiles;
                ES6FromClause fromClause;
                ES6ImportDeclaration declaration = ((ES6ImportedBinding)element).getDeclaration();
                ES6FromClause eS6FromClause = fromClause = declaration == null ? null : declaration.getFromClause();
                if (fromClause != null && !(referencedFiles = fromClause.resolveReferencedElements()).isEmpty()) {
                    boolean cssFilesOnly = true;
                    for (PsiElement file : referencedFiles) {
                        if (!(file instanceof StylesheetFile)) {
                            cssFilesOnly = false;
                            continue;
                        }
                        CssStylesheet stylesheet = ((StylesheetFile)file).getStylesheet();
                        if (stylesheet == null) continue;
                        QualifiedItemProcessor.processCssClasses(stylesheet, processor);
                    }
                    if (cssFilesOnly) {
                        return false;
                    }
                }
            } else if (element instanceof JSClassExpression) {
                boolean isStatic = !(evaluateContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement);
                return AccessibilityProcessingHandler.processWithStatic(processor, isStatic, (Producer<Boolean>)((Producer)() -> {
                    if (element == null) {
                        QualifiedItemProcessor.$$$reportNull$$$0(31);
                    }
                    if (processor == null) {
                        QualifiedItemProcessor.$$$reportNull$$$0(32);
                    }
                    if (place == null) {
                        QualifiedItemProcessor.$$$reportNull$$$0(33);
                    }
                    return element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), element, place);
                }));
            }
        }
        return true;
    }

    private static void processCssClasses(@NotNull CssStylesheet stylesheet, @NotNull JSResolveProcessor processor) {
        if (stylesheet == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
            QualifiedItemProcessor.processCssClasses(cssRuleset, processor);
        }
    }

    private static void processCssClasses(@NotNull CssRuleset cssRuleset, @NotNull JSResolveProcessor processor) {
        if (cssRuleset == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            for (CssSimpleSelector simpleSelector : cssSelector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    String name;
                    if (!(selectorSuffix instanceof CssClass) || (name = selectorSuffix.getName()) == null) continue;
                    processor.execute((PsiElement)selectorSuffix, ResolveState.initial());
                }
            }
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            QualifiedItemProcessor.processCssClasses((CssRuleset)cssSelector, processor);
        }
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        boolean processedDeclarationDirectly = false;
        boolean hasCallSignature = false;
        if (sourceElement != null && sourceElement.isValid()) {
            processedDeclarationDirectly = true;
            if (type instanceof JSSimpleRecordTypeImpl) {
                HashSet processed = ContainerUtil.newHashSet();
                if (sourceElement instanceof JSObjectLiteralExpression) {
                    for (JSProperty property : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                        if (!processed.add(property)) continue;
                        this.execute((PsiElement)property, ResolveState.initial());
                    }
                }
                block1: for (JSRecordType.TypeMember member : type.getTypeMembers()) {
                    Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember(member, sourceElement, false);
                    for (PsiElement psiElement : elements) {
                        if (psiElement == null || !processed.add(psiElement)) continue;
                        this.execute(psiElement, ResolveState.initial());
                        if (!(psiElement instanceof TypeScriptCallSignature)) continue;
                        hasCallSignature = true;
                        continue block1;
                    }
                }
            } else {
                if (sourceElement instanceof JSClassExpression) {
                    Stream<JSType> constructors = JSTypeUtils.getFunctionType((JSType)type, true);
                    this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
                    sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place);
                    return;
                }
                processedDeclarationDirectly = false;
            }
        }
        if (!processedDeclarationDirectly) {
            for (JSRecordType.TypeMember typeMember : type.getTypeMembers()) {
                hasCallSignature |= typeMember instanceof JSRecordType.CallSignature;
                if (!(typeMember instanceof JSRecordType.PropertySignature)) continue;
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
                String name = this.getName();
                this.processRecordProperty(sourceElement, propertySignature, name);
            }
        }
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement)) {
            this.processSuperClassMembers(sourceElement, hasCallSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature) {
        if (sourceElement == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature ? "Function" : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    private void processRecordProperty(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, @Nullable String name) {
        block6: {
            if (propertySignature == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(18);
            }
            if (name != null && !name.equals(propertySignature.getMemberName())) break block6;
            Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember((JSRecordType.TypeMember)propertySignature, sourceElement, true);
            if (this.getResultSink() instanceof ResolveResultSink && (sourceElement == null || !DialectDetector.isTypeScript(sourceElement))) {
                for (PsiElement element : elements) {
                    this.addPossibleCandidateResult(element, null);
                }
            } else {
                for (PsiElement element : elements) {
                    if (element instanceof JSImplicitElement) {
                        this.addResult(element);
                        continue;
                    }
                    this.execute(element, ResolveState.initial());
                }
            }
        }
    }

    @NotNull
    public static Collection<PsiElement> getElementsForTypeMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable PsiElement sourceElement, boolean createImplicitElement) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        if (typeMember instanceof PsiElement) {
            List list = ContainerUtil.list((Object[])new PsiElement[]{(PsiElement)typeMember});
            if (list == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (typeMember instanceof JSCompositeFunctionPropertySignatureImpl) {
            ArrayList results = ContainerUtil.newArrayList();
            for (JSRecordType.PropertySignature signature : ((JSCompositeFunctionPropertySignatureImpl)typeMember).getMembers()) {
                results.addAll(QualifiedItemProcessor.getElementsForTypeMember((JSRecordType.TypeMember)signature, sourceElement, createImplicitElement));
            }
            ArrayList arrayList = results;
            if (arrayList == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(21);
            }
            return arrayList;
        }
        JSRecordType.MemberSource ownSource = typeMember.getMemberSource();
        if (createImplicitElement && typeMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
            JSType propertySignatureType = propertySignature.getType();
            Collection<PsiElement> collection = QualifiedItemProcessor.createImplicitElements(sourceElement, propertySignature, propertySignatureType);
            if (collection == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(22);
            }
            return collection;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ownSource.getSingleElement());
        if (list == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static Collection<PsiElement> createImplicitElements(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, JSType propertySignatureType) {
        JSRecordType.MemberSource source;
        if (propertySignature == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(24);
        }
        if (!(source = propertySignature.getMemberSource()).getMemberSourceKind().isTypeScriptMergedTypeKind()) {
            PsiElement singleElement = source.getSingleElement();
            List list = ContainerUtil.createMaybeSingletonList((Object)((Object)new JSLocalImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, singleElement == null ? sourceElement : singleElement, null)));
            if (list == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(25);
            }
            return list;
        }
        Collection collection = source.getAllSourceElements().stream().filter(e -> e != null).map(e -> {
            if (propertySignature == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(30);
            }
            return new TypeScriptMergedTypeImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, (PsiElement)e);
        }).collect(Collectors.toList());
        if (collection == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(26);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeFromClass(JSType type, JSEvaluateContext evaluateContext, String typeString, PsiElement typeSource, boolean setTypeContext, JSQualifiedNamedElement jsClass) {
        JSExpression placeQualifier;
        JSReferenceExpression evaluateQualifier;
        if ("RemoteObject".equals(jsClass.getName()) && typeSource instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)typeSource).getType() == JSImplicitElement.Type.Tag) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((JSOffsetBasedImplicitElement)typeSource).getElementAtOffset(), XmlTag.class);
            for (XmlTag method : tag.findSubTags("method", tag.getNamespace())) {
                if (!this.execute((PsiElement)method, ResolveState.initial())) break;
            }
            this.resolved = TypeResolveState.Resolved;
            return;
        }
        boolean statics = false;
        if (!(!JSPsiImplUtils.isTheSameClass(typeSource, jsClass) || (evaluateQualifier = evaluateContext.getProcessedExpression()) == null || (placeQualifier = evaluateQualifier.getQualifier()) instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSParenthesizedExpression || placeQualifier instanceof JSParenthesizedExpression)) {
            statics = true;
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            statics = true;
        }
        this.getAccessibilityProcessingHandler().setProcessStatics(statics);
        if (statics) {
            this.setTypeName(jsClass.getQualifiedName());
        }
        boolean saveSetTypeContext = this.isTypeContext();
        boolean saveToProcessMembers = this.isToProcessMembers();
        if (setTypeContext) {
            this.setTypeContext(setTypeContext);
            this.setToProcessMembers(false);
        }
        try {
            JSAttributeList attrList;
            boolean b;
            if (this.resolved != TypeResolveState.Resolved && ("XML".equals(typeString) || "XMLList".equals(typeString))) {
                this.resolved = TypeResolveState.PrefixUnknown;
            }
            if (!(b = jsClass.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)jsClass, this.place))) {
                this.resolved = TypeResolveState.Resolved;
            }
            if (this.myEcma && ((attrList = ((JSAttributeListOwner)jsClass).getAttributeList()) == null || !attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                this.resolved = TypeResolveState.Resolved;
            }
        }
        finally {
            if (setTypeContext) {
                this.setTypeContext(saveSetTypeContext);
                this.setToProcessMembers(saveToProcessMembers);
            }
        }
    }

    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        return clazz instanceof JSClass;
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        return super.getResultsAsResolveResults();
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(27);
        }
        if (state == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(28);
        }
        if (this.needPackages() && !(element instanceof JSPackageWrapper)) {
            return true;
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        boolean b = super.execute(element, state);
        if (this.myEcma && this.getResult() != null) {
            this.resolved = TypeResolveState.Resolved;
        }
        return b;
    }

    @Override
    public void prefixResolved() {
        if (this.myEcma || this.myTypeScript) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element) {
        super.elementIsNotAccessible(element);
        if (this.myEcma || this.myTypeScript) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    @Override
    public PsiElement getTarget() {
        return null;
    }

    @Override
    public void setUnknownElement(@NotNull PsiElement element) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        if (!(element instanceof XmlToken)) {
            boolean currentIsNotResolved = QualifiedItemProcessor.isDummyResolve(element, this.place);
            this.resolved = currentIsNotResolved ? TypeResolveState.PrefixUnknown : TypeResolveState.Unknown;
        }
    }

    private static boolean isDummyResolve(PsiElement element, PsiElement place) {
        if (place instanceof JSReferenceExpressionImpl) {
            JSExpression originalQualifier = BaseJSSymbolProcessor.getOriginalQualifier(((JSReferenceExpressionImpl)place).getResolveQualifier());
            if (originalQualifier instanceof JSCallExpression) {
                originalQualifier = ((JSCallExpression)originalQualifier).getMethodExpression();
            }
            return originalQualifier == element;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: 
            case 8: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 18: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForTypeMember";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processActionScriptClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNamespace";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processCssClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRecordProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForTypeMember";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setUnknownElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createImplicitElements$3";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processResolvedElement$1";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processActionScriptClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        Undefined,
        PrefixUnknown;

    }
}

