/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, processingContext);
    }

    public static boolean isTypeInstanceOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext subtypingContext) {
        if (subtypingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        return TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context);
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, context);
    }

    public static boolean isTypeSubsetOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source == null || target == null) {
            return source == target;
        }
        if (source.isEquivalentTo(target, context)) {
            return true;
        }
        return target instanceof JSCompositeTypeImpl && TypeScriptTypeRelations.isTypeSubsetOfUnionType(source, (JSCompositeTypeImpl)target, context);
    }

    public static boolean isTypeRelatedTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(source).isDirectlyAssignableType(TypeScriptTypeRelations.getRegularTypeOfLiteralType(target), context);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSCompositeTypeImpl) {
            return ((JSCompositeTypeImpl)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context);
    }

    public static boolean isTypeSubsetOfUnionType(@NotNull JSType source, @NotNull JSCompositeTypeImpl target, @Nullable ProcessingContext context) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        if (target == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        List<JSType> types = target.getTypes();
        if (source instanceof JSCompositeTypeImpl) {
            List<JSType> subTypes = ((JSCompositeTypeImpl)source).getTypes();
            for (JSType type : subTypes) {
                if (TypeScriptTypeRelations.containsType(types, type, context)) continue;
                return false;
            }
            return true;
        }
        return TypeScriptTypeRelations.containsType(types, source, context);
    }

    public static boolean containsType(@NotNull List<JSType> types, @NotNull JSType sourceType, @Nullable ProcessingContext context) {
        if (types == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        if (sourceType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        return types.stream().anyMatch(el -> {
            if (sourceType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(20);
            }
            return el.isEquivalentTo(sourceType, context);
        });
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static JSType expandTypeRecursive(@Nullable JSType type) {
        return TypeScriptTypeRelations.expandTypeRecursive(type, null);
    }

    @Contract(value="!null,_ -> !null")
    static JSType expandTypeRecursive(@Nullable JSType type, @Nullable Set<String> ids) {
        JSType typedef;
        if (type == null) {
            return null;
        }
        JSType expanded = JSTypeUtils.getValuableType(type);
        if (expanded instanceof JSTypeImpl && expanded.isTypeScript() && (typedef = ((JSTypeImpl)expanded).getTypedef()) != null) {
            Set<Object> set = ids = ids == null ? ContainerUtil.newHashSet() : ids;
            if (ids.add(JSTypeCastUtil.getTypeIdForComparison(expanded))) {
                return TypeScriptTypeRelations.expandTypeRecursive(typedef, ids);
            }
        }
        if (expanded instanceof JSGenericTypeImpl) {
            JSType substitute;
            JSType expandedGenericOwner;
            Set<Object> newIds;
            JSType genericOwner = ((JSGenericTypeImpl)expanded).getType();
            Set<Object> set = newIds = ids == null ? ContainerUtil.newHashSet() : ids;
            if (newIds.add(JSTypeCastUtil.getTypeIdForComparison(expanded)) && (expandedGenericOwner = TypeScriptTypeRelations.expandTypeRecursive(genericOwner, newIds)) != genericOwner && (substitute = expanded.substitute()) != expanded) {
                return TypeScriptTypeRelations.expandTypeRecursive(substitute, ids);
            }
        }
        return expanded;
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        if (type == null) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(JSTypeSourceFactory.createTypeSource(context, true));
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(8);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if ((type = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(TypeScriptTypeRelations.expandTypeRecursive(type))) instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List<JSType> resultTypes = types.stream().filter(el -> {
                if (filter == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(19);
                }
                return filter.apply(el);
            }).collect(Collectors.toList());
            if (types.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(9);
                }
                return jSType;
            }
            JSType jSType = TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        Object object = filter.apply((Object)type) ? type : new TypeScriptNeverJSTypeImpl(type.getSource());
        if (object == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionTypeIfEnumWithLiterals(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType)) {
            return type;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        if (info != null && info.isEnumWithLiteralValues()) {
            JSType result = TypeScriptTypeRelations.createEnumValuesUnionType(type, info);
            return result == null ? type : result;
        }
        return type;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(12);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(13);
        }
        if (resultTypes.isEmpty()) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(source);
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(14);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (resultTypes.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem(resultTypes, null);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    protected static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if (valueType instanceof JSLiteralType && !((JSLiteralType)valueType).isStrict()) {
            return ((JSLiteralType)valueType).copyWithStrictness(true);
        }
        return valueType;
    }

    @Nullable
    public static JSType createEnumValuesUnionType(@NotNull JSType elementType, @NotNull JSResolvedTypeInfo resolvedType) {
        TypeScriptEnum enumDeclaration;
        if (elementType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(17);
        }
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(18);
        }
        if ((enumDeclaration = resolvedType.getDeclarationOfType(TypeScriptEnum.class)) == null) {
            return null;
        }
        JSField[] members = enumDeclaration.getFields();
        if (members.length == 0) {
            return null;
        }
        ArrayList combinedTypeMembers = ContainerUtil.newArrayListWithCapacity((int)members.length);
        for (JSField member : members) {
            combinedTypeMembers.add(JSNamedType.createType(elementType.getTypeText() + "." + member.getName(), JSTypeSourceFactory.createTypeSource((PsiElement)member, true), JSTypeContext.INSTANCE, false));
        }
        return new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)enumDeclaration, true), combinedTypeMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtypingContext";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeInstanceOf";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubsetOfUnionType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEnumValuesUnionType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterType$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsType$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

