/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMemberSearchParameters;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

abstract class JSMembersSearchImpl<T extends JSPsiElementBase>
implements QueryExecutor<T, JSMemberSearchParameters<T>> {
    JSMembersSearchImpl() {
    }

    public boolean execute(@NotNull JSMemberSearchParameters<T> queryParameters, @NotNull Processor<T> consumer) {
        Object baseMember;
        JSClass baseClass;
        if (queryParameters == null) {
            JSMembersSearchImpl.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSMembersSearchImpl.$$$reportNull$$$0(1);
        }
        if ((baseClass = JSUtils.getMemberContainingClass(baseMember = queryParameters.getBaseMember())) == null) {
            return true;
        }
        return this.makeQuery(queryParameters, baseClass).forEach(currentClass -> {
            String name;
            boolean lookInSupers;
            if (consumer == null) {
                JSMembersSearchImpl.$$$reportNull$$$0(2);
            }
            boolean bl = lookInSupers = baseClass.isInterface() && !currentClass.isInterface();
            if (baseMember instanceof JSFunction) {
                JSFunction function = JSInheritanceUtil.findMethodInClass((JSFunction)baseMember, currentClass, lookInSupers);
                if (JSMembersSearchImpl.isAcceptable((JSQualifiedNamedElement)function)) {
                    return consumer.process((Object)function);
                }
            } else if (baseMember instanceof JSField && (name = baseMember.getName()) != null) {
                JSQualifiedNamedElement member = JSInheritanceUtil.findMember(name, currentClass, JSInheritanceUtil.SearchedMemberType.Fields, null, lookInSupers);
                if (JSMembersSearchImpl.isAcceptable(member)) {
                    return consumer.process((Object)member);
                }
                if (!currentClass.isInterface()) {
                    member = JSInheritanceUtil.findMember(name, currentClass, JSInheritanceUtil.SearchedMemberType.Methods, JSFunction.FunctionKind.GETTER, lookInSupers);
                    if (JSMembersSearchImpl.isAcceptable(member) && !consumer.process((Object)member)) {
                        return false;
                    }
                    member = JSInheritanceUtil.findMember(name, currentClass, JSInheritanceUtil.SearchedMemberType.Methods, JSFunction.FunctionKind.SETTER, lookInSupers);
                    if (JSMembersSearchImpl.isAcceptable(member)) {
                        return consumer.process((Object)member);
                    }
                }
            }
            return true;
        });
    }

    private static boolean isAcceptable(JSQualifiedNamedElement member) {
        return member != null && JSInheritanceUtil.canHaveSuperMember((JSAttributeListOwner)member);
    }

    protected abstract Query<JSClass> makeQuery(JSMemberSearchParameters<T> var1, JSClass var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/search/JSMembersSearchImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class JSOverridingMembersSearch<T2 extends JSPsiElementBase>
    extends JSMembersSearchImpl<T2> {
        JSOverridingMembersSearch() {
        }

        @Override
        protected Query<JSClass> makeQuery(JSMemberSearchParameters<T2> queryParameters, JSClass parent) {
            return JSClassSearch.searchClassInheritors(parent, queryParameters.isCheckDeepInheritance());
        }
    }

    static class JSImplementingMembersSearch<T1 extends JSPsiElementBase>
    extends JSMembersSearchImpl<T1> {
        JSImplementingMembersSearch() {
        }

        @Override
        protected Query<JSClass> makeQuery(JSMemberSearchParameters<T1> queryParameters, JSClass parent) {
            return JSClassSearch.searchInterfaceImplementations(parent, true);
        }
    }
}

