/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ImplementJSDocMethodsFix
implements LocalQuickFix {
    final String myClassName;
    final Map<String, String> myNonImplemented;

    public ImplementJSDocMethodsFix(@NotNull String className, Map<String, String> nonImplemented) {
        if (className == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(0);
        }
        this.myClassName = className;
        this.myNonImplemented = nonImplemented;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.fix.implement.methods", (Object[])new Object[0]);
        if (string == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSSourceElement declarationOwner;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(3);
        }
        if ((declarationOwner = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSSourceElement.class, (boolean)false)) == null) {
            return;
        }
        if (declarationOwner instanceof JSClass) {
            for (Map.Entry<String, String> method : this.myNonImplemented.entrySet()) {
                String declaration = String.format("%s %s \n{}", method.getKey(), method.getValue());
                JSSourceElement methodImplementation = JSChangeUtil.createClassMemberPsiFromTextWithContext(declaration, (PsiElement)declarationOwner, JSSourceElement.class);
                if (methodImplementation == null) {
                    return;
                }
                methodImplementation = (JSSourceElement)JSRefactoringUtil.addMemberToTargetClass((JSClass)declarationOwner, (PsiElement)methodImplementation);
                FormatFixer.create((PsiElement)methodImplementation, FormatFixer.Mode.Reformat).fixFormat();
            }
        } else {
            for (Map.Entry<String, String> method : this.myNonImplemented.entrySet()) {
                String builder = this.myClassName + ".prototype." + method.getKey() + " = function" + method.getValue() + "{};";
                PsiElement methodImplementation = JSChangeUtil.createJSTreeFromTextWithContext(builder, (PsiElement)declarationOwner).getPsi();
                declarationOwner.getParent().addAfter(methodImplementation, (PsiElement)declarationOwner);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

