/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceUtil {
    public static final String LIB_DIRECTORY = "lib";
    public static final Condition<VirtualFile> IS_VALID_FILE_FOR_SERVICE = virtualFile -> virtualFile != null && virtualFile.isInLocalFileSystem();
    public static final Condition<VirtualFile> ACCEPTABLE_TS_FILE = virtualFile -> {
        if (!IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
            return false;
        }
        FileType type = virtualFile.getFileType();
        return TypeScriptCompilerSettings.acceptFileType(type) && virtualFile.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER) == null;
    };
    public static volatile boolean USE_SERVICE = false;

    public static void setUseService(boolean useService) {
        USE_SERVICE = useService;
    }

    public static boolean isServiceEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return TypeScriptLanguageServiceUtil.isServiceEnabled(settings);
    }

    public static boolean isServiceEnabled(@Nullable TypeScriptCompilerSettings settings) {
        if (settings == null || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        return settings.useService();
    }

    public static boolean useServiceCompletion(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(1);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean useServiceParameterInfo(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(2);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && ACCEPTABLE_TS_FILE.value((Object)file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceParameterInfo();
    }

    @Contract(value="null -> false")
    public static boolean checkProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && project.isOpen();
    }

    private static boolean useNewTypeScriptService(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.useService();
    }

    public static boolean shouldUseMainFile(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(3);
        }
        return settings.useMainFile();
    }

    @Nullable
    public static String getActualLibDirectory(@Nullable Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(4);
        }
        if (project == null || project.isDefault() || project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return null;
        }
        NodeJsInterpreter interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings);
        NodePackageDescriptor descriptor2 = TypeScriptNodePackageWrapper.createDescriptor(project, settings);
        NodePackage nodePackage = TypeScriptNodePackageWrapper.getPackageFromSettings(project, descriptor2, settings, interpreter);
        String path = nodePackage.getSystemIndependentPath();
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile modulePackage = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModulePackage(fileByPath);
        return modulePackage == null ? null : modulePackage.getPath();
    }

    @Nullable
    public static VirtualFile getTypeScriptLibFromNodeModulePackage(@Nullable VirtualFile nodeModulePackage) {
        if (nodeModulePackage == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(nodeModulePackage)) {
            return nodeModulePackage;
        }
        VirtualFile lib = nodeModulePackage.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(lib)) {
            return lib;
        }
        return null;
    }

    public static boolean hasServiceFiles(@NotNull VirtualFile lib) {
        VirtualFile[] children;
        if (lib == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(5);
        }
        if ((children = lib.getChildren()) != null) {
            for (VirtualFile file : children) {
                if (!ArrayUtil.contains((String)file.getName(), (String[])TypeScriptCompilerSettings.TYPESCRIPT_SERVICE_FILES)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String getNormalizedVersionString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }

    public static void fillFilePosition(@NotNull TypeScriptFileLocationRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull Document document, int positionInFileOffset) {
        if (args == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        if (document == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        if (document instanceof DocumentWindow) {
            positionInFileOffset = ((DocumentWindow)document).injectedToHost(positionInFileOffset);
            document = ((DocumentWindow)document).getDelegate();
        }
        int line = document.getLineNumber(positionInFileOffset);
        int offset = positionInFileOffset - document.getLineStartOffset(line);
        args.line = line + 1;
        args.offset = offset + 1;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile);
    }

    @Nullable
    public static NodeJsInterpreter getNodeInterpreter(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        String interpreter;
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        if ((interpreter = settings.getNodeInterpreter()) != null) {
            NodeJsInterpreterRef refName = NodeJsInterpreterRef.create(interpreter);
            return refName.resolve(project);
        }
        return NodeJsInterpreterManager.getInstance(project).getDefault();
    }

    @Nullable
    public static String getNodeInterpreterPath(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return JSLanguageServiceUtil.getInterpreterPathIfValid(TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings));
    }

    @Contract(value="!null,_->!null")
    public static String getRelativePath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)path)) {
            return StringUtil.notNullize((String)path);
        }
        return (String)ReadAction.compute(() -> {
            VirtualFile fileByPath;
            if (project == null) {
                TypeScriptLanguageServiceUtil.$$$reportNull$$$0(14);
            }
            if ((fileByPath = LocalFileSystem.getInstance().findFileByPath(path)) == null) {
                return path;
            }
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !project.isOpen()) {
                return path;
            }
            VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(fileByPath);
            if (root != null) {
                return "/" + VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)root);
            }
            return path;
        });
    }

    @Nullable
    public static JSLanguageServiceUtil.PsiElementInfo getPsiElementInfo(@Nullable PsiFile file, @NotNull Document document, @Nullable TypeScriptResponseCommon.Location start, @Nullable TypeScriptResponseCommon.Location end) {
        if (document == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(13);
        }
        if (start == null || end == null) {
            return null;
        }
        int line = start.line - 1;
        int startOffset = start.offset - 1;
        int endLine = end.line - 1;
        int endOffset = end.offset - 1;
        return JSLanguageServiceUtil.getElementInfo(file, document, line, startOffset, endLine, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = LIB_DIRECTORY;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "useServiceCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useServiceParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseMainFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getActualLibDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasServiceFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fillFilePosition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeInterpreter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiElementInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getRelativePath$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

