/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptPsiIcons;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceCompletionContributor
extends CompletionContributor {
    private static final Logger LOGGER = Logger.getInstance(TypeScriptLanguageServiceCompletionContributor.class);
    public static final long TIMEOUT_MILLS = 700L;
    public static final long NO_WAITING = 0L;
    private static final Set<String> FUNCTION_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"call", "method", "function", "local function"});
    public static final Couple<String> DEFAULT_SIGNATURE = Couple.of((Object)"(...)", null);
    public static final Key<Object> SERVICE_COMPLETION_KEY = Key.create((String)"service.item");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        long toWait;
        List<TypeScriptCompletionResponse.CompletionEntryDetail> details;
        PsiFile file;
        TypeScriptCompilerService tsService;
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((tsService = this.getServiceIfEnabled(parameters, file = parameters.getOriginalFile())) == null) {
            return;
        }
        Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> serviceFuture = this.getServiceEntriesFuture(tsService, file, parameters);
        if (serviceFuture == null) {
            return;
        }
        LinkedHashMap remainingCollectedItems = ContainerUtil.newLinkedHashMap();
        LinkedHashMap namesWithServiceCompletionEntries = ContainerUtil.newLinkedHashMap();
        Ref serviceFutureWasDone = Ref.create((Object)((Object)State.NOT_COMPLETED));
        HashSet smartPriorityItems = ContainerUtil.newHashSet();
        long startProcessTime = System.currentTimeMillis();
        resultSet.runRemainingContributors(parameters, completionResult -> {
            void el;
            LookupElement element;
            double priority;
            if (resultSet == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(35);
            }
            if ((priority = JSCompletionUtil.getLookupElementPriority(element = el.getLookupElement())) >= (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue()) {
                resultSet.passResult((CompletionResult)el);
                String lookupString = element.getLookupString();
                smartPriorityItems.add(lookupString);
                namesWithServiceCompletionEntries.remove(lookupString);
                return;
            }
            State state = (State)((Object)((Object)serviceFutureWasDone.get()));
            if (state == State.NOT_COMPLETED) {
                if (!serviceFuture.isDone() && TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime) >= 0L) {
                    TypeScriptLanguageServiceCompletionContributor.addElementToRemainingMap(remainingCollectedItems, (CompletionResult)el);
                    return;
                }
                List details = (List)JSLanguageServiceUtil.awaitFuture(serviceFuture, 0L, 0L, null);
                State newState = TypeScriptLanguageServiceCompletionContributor.getStateByDetails(details);
                serviceFutureWasDone.set((Object)newState);
                if (newState == State.COMPLETED && details != null) {
                    namesWithServiceCompletionEntries.putAll(ContainerUtil.map2Map((Collection)details, detail -> Pair.create((Object)detail.name, (Object)detail)));
                    smartPriorityItems.forEach(smartItem -> {
                        TypeScriptCompletionResponse.CompletionEntryDetail cfr_ignored_0 = (TypeScriptCompletionResponse.CompletionEntryDetail)namesWithServiceCompletionEntries.remove(smartItem);
                    });
                    this.processCollectedRemainingItems(resultSet, remainingCollectedItems, namesWithServiceCompletionEntries);
                } else {
                    remainingCollectedItems.forEach((key, val) -> {
                        if (resultSet == null) {
                            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(36);
                        }
                        resultSet.passResult(val);
                    });
                }
                remainingCollectedItems.clear();
            } else if (state == State.COMPLETED_EMPTY) {
                resultSet.passResult((CompletionResult)el);
            } else {
                this.processRemainingItem(resultSet, (CompletionResult)el, namesWithServiceCompletionEntries);
            }
        });
        State state = (State)((Object)serviceFutureWasDone.get());
        if (state == State.NOT_COMPLETED && (state = TypeScriptLanguageServiceCompletionContributor.getStateByDetails(details = JSLanguageServiceUtil.awaitFuture(serviceFuture, toWait = TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime), 10L, null))) == State.COMPLETED && details != null) {
            namesWithServiceCompletionEntries.putAll(ContainerUtil.map2Map(details, detail -> Pair.create((Object)detail.name, (Object)detail)));
        }
        if (state == State.COMPLETED_EMPTY) {
            remainingCollectedItems.forEach((key, val) -> {
                if (resultSet == null) {
                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(34);
                }
                resultSet.passResult(val);
            });
            resultSet.stopHere();
            return;
        }
        smartPriorityItems.forEach(el -> {
            TypeScriptCompletionResponse.CompletionEntryDetail cfr_ignored_0 = (TypeScriptCompletionResponse.CompletionEntryDetail)namesWithServiceCompletionEntries.remove(el);
        });
        this.processAllServiceCompletionEntries(parameters, resultSet, remainingCollectedItems, namesWithServiceCompletionEntries, tsService, startProcessTime);
        resultSet.stopHere();
    }

    @Nullable
    public TypeScriptCompilerService getServiceIfEnabled(@NotNull CompletionParameters parameters, @Nullable PsiFile file) {
        VirtualFile virtualFile;
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!this.isAvailableForFile(file)) {
            return null;
        }
        if (parameters.isExtendedCompletion()) {
            return null;
        }
        if (!this.isApplicablePlaceForCompletion(parameters.getPosition())) {
            return null;
        }
        Project project = parameters.getOriginalFile().getProject();
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, virtualFile = this.getVirtualFile(file));
        if (service == null || !service.checkCanUseService()) {
            return null;
        }
        if (!(service.isServiceCreated() || !DumbService.isDumb((Project)project) && TypeScriptConfigService.Provider.hasConfigs(project))) {
            return null;
        }
        return service;
    }

    @Contract(value="null -> false")
    protected boolean isAvailableForFile(@Nullable PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile.isInLocalFileSystem() && TypeScriptLanguageServiceUtil.useServiceCompletion(file.getProject(), virtualFile);
    }

    private static long timeToWait(long startProcess) {
        long diffAwaited = System.currentTimeMillis() - startProcess;
        return 700L - diffAwaited;
    }

    private static void addElementToRemainingMap(@NotNull Map<String, CompletionResult> remainingCollectedItems, @NotNull CompletionResult completionResult) {
        LookupElement element;
        String lookupString;
        CompletionResult oldCompletionResult;
        if (remainingCollectedItems == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(3);
        }
        if (completionResult == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((oldCompletionResult = remainingCollectedItems.get(lookupString = (element = completionResult.getLookupElement()).getLookupString())) != null) {
            LookupElement oldLookupElement = oldCompletionResult.getLookupElement();
            if (!(oldLookupElement instanceof TypeScriptOverloadLookupElementDecorator)) {
                CompletionResult decoratedItem = oldCompletionResult.withLookupElement(TypeScriptLanguageServiceCompletionContributor.overloadDecorator(oldLookupElement));
                remainingCollectedItems.put(lookupString, decoratedItem);
            }
        } else {
            remainingCollectedItems.put(lookupString, completionResult);
        }
    }

    @NotNull
    private static State getStateByDetails(List<TypeScriptCompletionResponse.CompletionEntryDetail> details) {
        State state = details != null && !details.isEmpty() ? State.COMPLETED : State.COMPLETED_EMPTY;
        if (state == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(5);
        }
        return state;
    }

    private void processRemainingItem(@NotNull CompletionResultSet resultSet, CompletionResult el, Map<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithCompletionEntries) {
        LookupElement lookupElement;
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(6);
        }
        if (namesWithCompletionEntries.isEmpty()) {
            return;
        }
        LookupElement element = el.getLookupElement();
        TypeScriptCompletionResponse.CompletionEntryDetail item = namesWithCompletionEntries.remove(element.getLookupString());
        if (item != null && (lookupElement = this.createLookupElement(item, element)) != null) {
            resultSet.passResult(el.withLookupElement(lookupElement));
        }
    }

    private void processCollectedRemainingItems(@NotNull CompletionResultSet resultSet, Map<String, CompletionResult> completionResults, Map<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithCompletionEntries) {
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(7);
        }
        ArrayList toRemove = ContainerUtil.newArrayList();
        namesWithCompletionEntries.forEach((name, entry) -> {
            CompletionResult result;
            if (resultSet == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(33);
            }
            if ((result = (CompletionResult)completionResults.remove(name)) != null) {
                toRemove.add(name);
                LookupElement el = this.createLookupElement((TypeScriptCompletionResponse.CompletionEntryDetail)entry, result.getLookupElement());
                if (el != null) {
                    resultSet.consume(el);
                }
            }
        });
        toRemove.forEach(namesWithCompletionEntries::remove);
    }

    private void processAllServiceCompletionEntries(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet, Map<String, CompletionResult> completionResults, Map<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithCompletionEntries, @NotNull TypeScriptCompilerService tsService, long startProcessTime) {
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(8);
        }
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(9);
        }
        if (tsService == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(10);
        }
        ArrayList entriesWithoutDetails = ContainerUtil.newArrayList();
        namesWithCompletionEntries.forEach((name, entry) -> {
            CompletionResult result;
            LookupElement oldLookup;
            if (resultSet == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(32);
            }
            LookupElement lookupElement = oldLookup = (result = (CompletionResult)completionResults.remove(name)) == null ? null : result.getLookupElement();
            if (oldLookup != null) {
                LookupElement el = this.createLookupElement((TypeScriptCompletionResponse.CompletionEntryDetail)entry, oldLookup);
                if (el != null) {
                    resultSet.consume(el);
                }
            } else {
                entriesWithoutDetails.add(entry);
            }
        });
        if (!entriesWithoutDetails.isEmpty()) {
            ArrayList result = this.getDetailedEntries(parameters, tsService, entriesWithoutDetails, startProcessTime);
            if (result == null) {
                result = entriesWithoutDetails;
            }
            result.forEach(item -> {
                LookupElement el;
                if (resultSet == null) {
                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(31);
                }
                if ((el = this.createLookupElement((TypeScriptCompletionResponse.CompletionEntryDetail)item, null)) != null) {
                    resultSet.consume(el);
                }
            });
        }
    }

    @Nullable
    protected List<TypeScriptCompletionResponse.CompletionEntryDetail> getDetailedEntries(@NotNull CompletionParameters parameters, @NotNull TypeScriptCompilerService tsService, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> entriesWithoutDetails, long startProcessTime) {
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(11);
        }
        if (tsService == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(12);
        }
        if (entriesWithoutDetails == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(13);
        }
        PsiFile file = parameters.getOriginalFile();
        VirtualFile virtualFile = this.getVirtualFile(file);
        Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> detailedItems = tsService.getDetailedCompletionItems(virtualFile, entriesWithoutDetails, parameters.getEditor().getDocument(), parameters.getOffset());
        long toWait = TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime);
        if (toWait > 0L) {
            return JSLanguageServiceUtil.awaitFuture(detailedItems, toWait, 10L, null);
        }
        return null;
    }

    @Nullable
    protected Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getServiceEntriesFuture(@NotNull TypeScriptCompilerService service, @NotNull PsiFile file, @NotNull CompletionParameters parameters) {
        if (service == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(14);
        }
        if (file == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(15);
        }
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = this.getVirtualFile(file);
        return service.updateAndGetCompletionItems(virtualFile, file, parameters.getEditor().getDocument(), parameters.getOffset());
    }

    protected VirtualFile getVirtualFile(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(17);
        }
        return file.getVirtualFile();
    }

    protected boolean isApplicablePlaceForCompletion(PsiElement position) {
        PsiElement parent = position.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof JSXmlAttributeImpl) {
            return true;
        }
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() != null) {
            return true;
        }
        if (parent instanceof JSReferenceExpression && TypeScriptLanguageServiceCompletionContributor.isShorthandedProperty(parent)) {
            return true;
        }
        return parent instanceof JSVariable && parent.getParent() instanceof JSDestructuringProperty;
    }

    private static boolean isShorthandedProperty(@NotNull PsiElement parent) {
        PsiElement candidate;
        if (parent == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(18);
        }
        return (candidate = parent.getParent()) instanceof ES6Property && ((ES6Property)candidate).isShorthanded();
    }

    @Nullable
    private LookupElement createLookupElement(@NotNull TypeScriptCompletionResponse.CompletionEntryDetail entry, @Nullable LookupElement realSource) {
        LookupElement serviceLookupItem;
        if (entry == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(19);
        }
        if ((serviceLookupItem = this.createLookupElementImpl(entry, realSource)) != null && ApplicationManager.getApplication().isUnitTestMode()) {
            serviceLookupItem.putUserData(SERVICE_COMPLETION_KEY, (Object)Boolean.TRUE);
        }
        return serviceLookupItem;
    }

    @Nullable
    protected LookupElement createLookupElementImpl(final @NotNull TypeScriptCompletionResponse.CompletionEntryDetail entry, @Nullable LookupElement realSource) {
        String signature;
        LookupElementBuilder item;
        int defaultProximity;
        if (entry == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(20);
        }
        ProgressManager.checkCanceled();
        final String kind = entry.kind;
        final String kindModifiers = entry.kindModifiers;
        boolean isFunction = FUNCTION_TYPES.contains(kind);
        final String lookupString = entry.name;
        if (lookupString == null) {
            return null;
        }
        LookupElement lookupSource = realSource;
        PsiElement psiSource = lookupSource == null ? null : lookupSource.getPsiElement();
        String source = psiSource == null ? lookupString : psiSource;
        int defaultPriority = JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getPriorityValue();
        double sourcePriority = defaultPriority;
        int sourceProximity = defaultProximity = JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getProximityValue();
        int sourceGrouping = 0;
        InsertHandler sourceInsertHandler = null;
        boolean hasPriority = false;
        if (lookupSource instanceof TypeScriptOverloadLookupElementDecorator) {
            lookupSource = ((TypeScriptOverloadLookupElementDecorator)lookupSource).getDelegate();
        }
        if (lookupSource instanceof PrioritizedLookupElement) {
            PrioritizedLookupElement prioritizedLookupElement = (PrioritizedLookupElement)lookupSource;
            sourcePriority = prioritizedLookupElement.getPriority();
            sourceProximity = prioritizedLookupElement.getExplicitProximity();
            sourceGrouping = prioritizedLookupElement.getGrouping();
            lookupSource = prioritizedLookupElement.getDelegate();
            hasPriority = true;
        }
        if (lookupSource instanceof LookupElementBuilder) {
            item = (LookupElementBuilder)lookupSource;
            sourceInsertHandler = ((LookupElementBuilder)lookupSource).getInsertHandler();
        } else {
            item = LookupElementBuilder.create((Object)source, (String)lookupString);
            if (lookupSource instanceof LookupItem) {
                item = item.withBoldness(((LookupItem)lookupSource).isBold());
                if (!hasPriority) {
                    sourcePriority = ((LookupItem)lookupSource).getPriority();
                    hasPriority = true;
                }
            }
        }
        final boolean isLowPriority = TypeScriptLanguageServiceCompletionContributor.isLowPriority(psiSource);
        final Couple<String> signatureAndReturn = isFunction ? TypeScriptLanguageServiceCompletionContributor.getSignatureAndResultType(entry) : null;
        int moveCaret = 1;
        if (signatureAndReturn != null && (signature = (String)signatureAndReturn.first) != null && signatureAndReturn.second != null && signature.length() == 2) {
            moveCaret = 2;
        }
        int toMoveCaret = moveCaret;
        if ((signatureAndReturn == DEFAULT_SIGNATURE || !isFunction && !(psiSource instanceof JSFunction)) && realSource != null) {
            TypeScriptFunction function;
            if (source instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadsWithImplementation(function = (TypeScriptFunction)source).size() > 0) {
                return TypeScriptLanguageServiceCompletionContributor.overloadDecorator(realSource);
            }
            return sourcePriority <= 1.0 ? PrioritizedLookupElement.withExplicitProximity((LookupElement)TypeScriptLanguageServiceCompletionContributor.withPriority(realSource, defaultPriority), (int)defaultProximity) : realSource;
        }
        item = item.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(lookupString);
                Icon icon = TypeScriptLanguageServiceCompletionContributor.this.getIcon(kind, kindModifiers);
                if (icon != null) {
                    presentation.setIcon(icon);
                }
                presentation.setItemTextBold(!isLowPriority);
                if (signatureAndReturn != null) {
                    String signature = (String)signatureAndReturn.first;
                    String returnType = (String)signatureAndReturn.second;
                    if (signature != null) {
                        presentation.setTailText(signature);
                    }
                    if (returnType != null) {
                        presentation.setTypeText(returnType);
                    }
                } else {
                    String type = TypeScriptLanguageServiceCompletionContributor.readPropertyType(entry);
                    if (type != null) {
                        presentation.setTypeText(type);
                    }
                }
            }
        });
        if (isFunction && sourceInsertHandler == null) {
            item = item.withInsertHandler(TypeScriptLanguageServiceCompletionContributor.createFunctionInsertHandler(toMoveCaret));
        }
        if (isLowPriority) {
            return TypeScriptLanguageServiceCompletionContributor.withPriority((LookupElement)item, -1.0);
        }
        return hasPriority ? PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)TypeScriptLanguageServiceCompletionContributor.withPriority((LookupElement)item, sourcePriority), (int)sourceGrouping), (int)sourceProximity) : item;
    }

    @Contract(value="!null -> !null")
    private static LookupElement overloadDecorator(LookupElement lookupSource) {
        if (lookupSource instanceof TypeScriptOverloadLookupElementDecorator || lookupSource == null) {
            return lookupSource;
        }
        return new TypeScriptOverloadLookupElementDecorator(lookupSource);
    }

    private static LookupElement withPriority(@NotNull LookupElement element, double newPriority) {
        if (element == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(21);
        }
        if (element instanceof LookupItem) {
            ((LookupItem)element).setPriority(newPriority);
        } else if (element instanceof LookupElementBuilder) {
            return PrioritizedLookupElement.withPriority((LookupElement)element, (double)newPriority);
        }
        return element;
    }

    private static boolean isLowPriority(PsiElement psiSource) {
        String name;
        JSClass memberContainingClass;
        return psiSource instanceof JSElement && (memberContainingClass = JSUtils.getMemberContainingClass(psiSource)) != null && ("Function".equals(name = memberContainingClass.getName()) || "Object".equals(name));
    }

    @NotNull
    private static InsertHandler<LookupElement> createFunctionInsertHandler(final int toMoveCaret) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                JSInsertHandler.insertBracesIfNeed(context, toMoveCaret);
            }
        };
        if (insertHandler == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(22);
        }
        return insertHandler;
    }

    @NotNull
    private static Couple<String> getSignatureAndResultType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        StringBuilder signature;
        int cursor;
        TypeScriptSymbolDisplayPart[] parts;
        block21: {
            int indexToStart;
            block20: {
                block19: {
                    int indexToStartReadParameter;
                    block18: {
                        block17: {
                            block16: {
                                Couple<String> couple;
                                try {
                                    parts = entry.displayParts;
                                    if (parts != null && parts.length != 0) break block16;
                                    couple = DEFAULT_SIGNATURE;
                                }
                                catch (Exception e) {
                                    LOGGER.error(e.getMessage(), (Throwable)e);
                                    Couple<String> couple2 = DEFAULT_SIGNATURE;
                                    if (couple2 == null) {
                                        TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(30);
                                    }
                                    return couple2;
                                }
                                if (couple == null) {
                                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(23);
                                }
                                return couple;
                            }
                            indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
                            if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) break block17;
                            Couple<String> couple = DEFAULT_SIGNATURE;
                            if (couple == null) {
                                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(24);
                            }
                            return couple;
                        }
                        indexToStartReadParameter = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, '(');
                        if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStartReadParameter)) break block18;
                        Couple<String> couple = DEFAULT_SIGNATURE;
                        if (couple == null) {
                            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(25);
                        }
                        return couple;
                    }
                    cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStartReadParameter);
                    if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block19;
                    Couple<String> couple = DEFAULT_SIGNATURE;
                    if (couple == null) {
                        TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(26);
                    }
                    return couple;
                }
                signature = new StringBuilder();
                cursor = TypeScriptLanguageServiceCompletionContributor.readFunctionSignature(parts, cursor, signature);
                if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block20;
                Couple couple = Couple.of((Object)signature.toString(), null);
                if (couple == null) {
                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(27);
                }
                return couple;
            }
            cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block21;
            Couple couple = Couple.of((Object)signature.toString(), null);
            if (couple == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(28);
            }
            return couple;
        }
        String typeText = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
        Couple couple = Couple.of((Object)signature.toString(), (Object)typeText);
        if (couple == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(29);
        }
        return couple;
    }

    private static int skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (TypeScriptLanguageServiceCompletionContributor.isWhitespace(part.kind)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static String readPropertyType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        try {
            TypeScriptSymbolDisplayPart[] parts = entry.displayParts;
            if (parts == null || parts.length == 0) {
                return null;
            }
            int indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
                return null;
            }
            int cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStart);
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
                return null;
            }
            cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
                return null;
            }
            String typeText = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
            if (!StringUtil.isEmpty((String)typeText)) {
                return typeText;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static int readFunctionSignature(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        ArrayDeque<Boolean> openedBraces = new ArrayDeque<Boolean>();
        openedBraces.add(true);
        signature.append("(");
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) {
                openedBraces.add(true);
            }
            if (TypeScriptLanguageServiceCompletionContributor.isCloseBrace(kind, text)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceResponseParser.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static int skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        ArrayDeque<Boolean> braces = new ArrayDeque<Boolean>();
        boolean firstBraceAdded = false;
        for (int i = 0; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (!firstBraceAdded) {
                if (!TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) continue;
                int nextToken = i + 1;
                if (nextToken < parts.length && "parameterName".equals(parts[nextToken].kind)) {
                    return i;
                }
                braces.add(true);
                firstBraceAdded = true;
                continue;
            }
            TypeScriptLanguageServiceCompletionContributor.fillBraces(braces, kind, text);
            if (!braces.isEmpty()) continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean isWhitespace(String kind) {
        return "space".equals(kind);
    }

    private static boolean isOpenBrace(String kind, String text) {
        return "punctuation".equals(kind) && text.equals("(");
    }

    private static boolean isCloseBrace(String kind, String text) {
        return "punctuation".equals(kind) && text.equals(")");
    }

    private static void fillBraces(Deque<Boolean> braces, String kind, String text) {
        if ("punctuation".equals(kind)) {
            if (text.equals(")")) {
                braces.pop();
            } else if (text.equals("(")) {
                braces.add(true);
            }
        }
    }

    @Nullable
    protected Icon getIcon(String kind, @Nullable String kindModifiers) {
        Icon resultIcon = TypeScriptLanguageServiceCompletionContributor.getKindIcon(kind);
        if (resultIcon != null) {
            String[] modifiers = kindModifiers == null ? ArrayUtil.EMPTY_STRING_ARRAY : kindModifiers.split(",");
            boolean isStatic = false;
            boolean isReadonly = false;
            boolean hasVisibility = false;
            for (String modifier : modifiers) {
                Icon modifierIcon;
                modifier = StringUtil.trim((String)modifier);
                if (!hasVisibility && (modifierIcon = TypeScriptLanguageServiceCompletionContributor.getVisibilityIcon(modifier)) != null) {
                    resultIcon = ElementBase.buildRowIcon((Icon)resultIcon, (Icon)modifierIcon);
                    hasVisibility = true;
                }
                if ("static".equals(modifier)) {
                    isStatic = true;
                }
                if (!"readonly".equals(modifier)) continue;
                isReadonly = true;
            }
            if (!hasVisibility) {
                resultIcon = ElementBase.buildRowIcon((Icon)resultIcon, (Icon)JSLookupUtilImpl.getEmptyIcon());
            }
            resultIcon = JSStubElementImpl.blendFlags(resultIcon, isStatic, isReadonly);
        }
        return resultIcon;
    }

    private static Icon getVisibilityIcon(String modifier) {
        switch (modifier) {
            case "private": {
                return PlatformIcons.PRIVATE_ICON;
            }
            case "protected": {
                return PlatformIcons.PROTECTED_ICON;
            }
            case "export": 
            case "public": 
            case "declare": {
                return PlatformIcons.PUBLIC_ICON;
            }
        }
        return null;
    }

    @Nullable
    protected static Icon getKindIcon(@Nullable String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "function": 
            case "local function": {
                return PlatformIcons.FUNCTION_ICON;
            }
            case "method": 
            case "call": 
            case "index": {
                return PlatformIcons.METHOD_ICON;
            }
            case "construct": 
            case "constructor": {
                return JavaScriptPsiIcons.Members.Constructor;
            }
            case "getter": 
            case "setter": 
            case "property": {
                return PlatformIcons.FIELD_ICON;
            }
            case "class": {
                return JavaScriptPsiIcons.Classes.TypeScriptClass;
            }
            case "interface": {
                return JavaScriptPsiIcons.Classes.Typescript_Interface;
            }
            case "enum": {
                return JavaScriptPsiIcons.Classes.Typescript_Enum;
            }
            case "module": {
                return JavaScriptPsiIcons.Classes.Typescript_Module;
            }
        }
        return PlatformIcons.VARIABLE_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingCollectedItems";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResult";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsService";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entriesWithoutDetails";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateByDetails";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionInsertHandler";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureAndResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServiceIfEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addElementToRemainingMap";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRemainingItem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processCollectedRemainingItems";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllServiceCompletionEntries";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedEntries";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getServiceEntriesFuture";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandedProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withPriority";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllServiceCompletionEntries$9";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllServiceCompletionEntries$8";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCollectedRemainingItems$7";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillCompletionVariants$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillCompletionVariants$3";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeScriptOverloadLookupElementDecorator
    extends LookupElementDecorator<LookupElement> {
        public TypeScriptOverloadLookupElementDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            String text = presentation.getTailText();
            if (text != null) {
                presentation.setTypeText(text + " (+ overloads)");
            }
        }
    }

    static enum State {
        NOT_COMPLETED,
        COMPLETED,
        COMPLETED_EMPTY;

    }
}

