/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptDeprecatedSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptExternalSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigurable
implements SearchableConfigurable {
    public static final String TYPESCRIPT_CONFIG_ID = "settings.typescriptcompiler";
    private final Project myProject;
    private final TypeScriptCompilerSettings myServiceSettings;
    private final TypeScriptSettings mySettings;
    private TypeScriptDeprecatedSettingsPanel myDeprecatedSettingsPanel;
    private volatile UIHolder myUIHolder;

    public TypeScriptConfigurable(Project project) {
        this.myProject = project;
        this.myServiceSettings = TypeScriptCompilerSettings.getSettings(project);
        this.mySettings = TypeScriptSettings.getSettings(project);
    }

    @NotNull
    public String getId() {
        if (TYPESCRIPT_CONFIG_ID == null) {
            TypeScriptConfigurable.$$$reportNull$$$0(0);
        }
        return TYPESCRIPT_CONFIG_ID;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"typescript.compiler.configurable.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.typescript";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myUIHolder == null) {
            this.myUIHolder = new UIHolder();
        }
        return this.myUIHolder.myWrapperPanel;
    }

    public void apply() throws ConfigurationException {
        if (this.myUIHolder == null) {
            return;
        }
        if (this.myProject.isDefault()) {
            this.myUIHolder.apply();
            return;
        }
        WriteAction.run(() -> {
            this.myUIHolder.apply();
            TypeScriptCompilerService.restartServices(this.myProject);
        });
        ApplicationManager.getApplication().invokeLater(() -> EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications(), this.myProject.getDisposed());
    }

    public void reset() {
        if (this.myUIHolder == null) {
            return;
        }
        this.myUIHolder.reset();
    }

    public void disposeUIResources() {
    }

    private static List<TypeScriptServerServiceSettings> getAdditionalSettings(Project project) {
        if (project == null || project.isDefault()) {
            return ContainerUtil.emptyList();
        }
        return TypeScriptCompilerService.getAll(project).stream().map(el -> el.getServiceSettings()).filter(el -> el != null).collect(Collectors.toList());
    }

    public boolean isModified() {
        if (this.myUIHolder == null) {
            return false;
        }
        return this.myUIHolder.isModified();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable", "getId"));
    }

    private final class UIHolder {
        private final JPanel myServiceRelatedOptions;
        private final JCheckBox myEnableServiceForProjectsWithoutConfig;
        private final JBTextField myDefaultOptions;
        private final NodeJsInterpreterField myNodeInterpreterTextField;
        private final JPanel myWrapperPanel;
        private final TypeScriptExternalSettingsPanel myExternalSettingsPanel;
        private ScopeChooserCombo myScopeChooserCombo;
        private JCheckBox myRecompileOnChanges;
        private final TypeScriptNodePackageWrapper myTypeScriptNodePackageWrapper;
        private final JBCheckBox myUseService;
        private final LabeledComponent<JBTextField> myDefaultOptionsComponent;

        private UIHolder() {
            FormBuilder mainFormBuilder = FormBuilder.createFormBuilder();
            this.myNodeInterpreterTextField = new NodeJsInterpreterField(TypeScriptConfigurable.this.myProject, false);
            this.myNodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.createProjectRef());
            mainFormBuilder.addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterTextField));
            this.myTypeScriptNodePackageWrapper = new TypeScriptNodePackageWrapper(TypeScriptConfigurable.this.myProject, this.myNodeInterpreterTextField, TypeScriptConfigurable.this.myServiceSettings);
            mainFormBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.version", (Object[])new Object[0]), (JComponent)((Object)this.myTypeScriptNodePackageWrapper.getField()));
            this.myUseService = new JBCheckBox(JSBundle.message((String)"typescript.use.service.configurable.options.enable", (Object[])new Object[0]));
            this.myUseService.setBorder((Border)JBUI.Borders.empty());
            this.myEnableServiceForProjectsWithoutConfig = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.enable.no.config", (Object[])new Object[0]));
            this.myEnableServiceForProjectsWithoutConfig.setBorder((Border)JBUI.Borders.empty());
            FormBuilder serviceNestedOptionsBuilder = FormBuilder.createFormBuilder();
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myEnableServiceForProjectsWithoutConfig);
            this.myExternalSettingsPanel = new TypeScriptExternalSettingsPanel(TypeScriptConfigurable.getAdditionalSettings(TypeScriptConfigurable.this.myProject), serviceNestedOptionsBuilder);
            this.appendScopeAndRecompileOnChanges(serviceNestedOptionsBuilder);
            this.myDefaultOptions = new JBTextField();
            this.myDefaultOptionsComponent = LabeledComponent.create((JComponent)this.myDefaultOptions, (String)JSBundle.message((String)"typescript.compiler.configurable.options.command.line", (Object[])new Object[0]), (String)"West");
            serviceNestedOptionsBuilder.addComponent(this.myDefaultOptionsComponent);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel = new TypeScriptDeprecatedSettingsPanel(TypeScriptConfigurable.this.myProject, TypeScriptConfigurable.this.myServiceSettings);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.buildUIFor(serviceNestedOptionsBuilder);
            this.myServiceRelatedOptions = serviceNestedOptionsBuilder.getPanel();
            this.myServiceRelatedOptions.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
            compilerOptionsWrapper.add((Component)this.myServiceRelatedOptions, "North");
            this.myUseService.addChangeListener(el -> this.updateVisibility());
            mainFormBuilder.addComponent((JComponent)this.myUseService);
            mainFormBuilder.addComponent((JComponent)compilerOptionsWrapper);
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.myWrapperPanel.add((Component)mainFormBuilder.getPanel(), "North");
            this.updateVisibility();
        }

        private void updateVisibility() {
            boolean isServiceEnabled = this.myUseService.isSelected();
            UIUtil.setEnabled((Component)this.myServiceRelatedOptions, (boolean)isServiceEnabled, (boolean)true);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.updateUI(!isServiceEnabled);
        }

        private void appendScopeAndRecompileOnChanges(FormBuilder parentBuilder) {
            this.myRecompileOnChanges = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.track.file.system", (Object[])new Object[0]));
            this.myRecompileOnChanges.setBorder((Border)JBUI.Borders.empty());
            parentBuilder.addComponent((JComponent)this.myRecompileOnChanges);
            if (!TypeScriptConfigurable.this.myProject.isDefault()) {
                this.myScopeChooserCombo = new ScopeChooserCombo();
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add((Component)this.myScopeChooserCombo, "West");
                wrapper.setBorder((Border)JBUI.Borders.empty());
                wrapper.add(Box.createHorizontalGlue(), "Center");
                parentBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.scope", (Object[])new Object[0]), (JComponent)wrapper);
            } else {
                this.myScopeChooserCombo = null;
            }
        }

        private void apply() throws ConfigurationException {
            TypeScriptConfigurable.this.myServiceSettings.setUseServiceForProjectsWithoutConfig(this.myEnableServiceForProjectsWithoutConfig.isSelected());
            TypeScriptConfigurable.this.myServiceSettings.setDefaultServiceOptions(this.myDefaultOptions.getText());
            TypeScriptConfigurable.this.myServiceSettings.setNodeInterpreter(this.getNodeInterpreterValueForStore());
            if (this.myScopeChooserCombo != null) {
                String scopeName = this.myScopeChooserCombo.getSelectedScopeName();
                TypeScriptConfigurable.this.myServiceSettings.setScopeName(scopeName == null ? "Project Files" : scopeName);
            }
            TypeScriptConfigurable.this.myServiceSettings.setRecompileOnChanges(this.myRecompileOnChanges.isSelected());
            this.myTypeScriptNodePackageWrapper.apply();
            this.myExternalSettingsPanel.apply();
            TypeScriptConfigurable.this.myServiceSettings.setUseService(this.myUseService.isSelected());
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.apply();
        }

        private void reset() {
            this.myEnableServiceForProjectsWithoutConfig.setSelected(TypeScriptConfigurable.this.myServiceSettings.useServiceForProjectsWithoutConfig());
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            this.setNodeInterpreterField(this.myNodeInterpreterTextField);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.reset();
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            if (this.myScopeChooserCombo != null) {
                this.myScopeChooserCombo.init(TypeScriptConfigurable.this.myProject, false, false, TypeScriptConfigurable.this.myServiceSettings.getScopeName());
                this.myScopeChooserCombo.setUsageView(false);
                this.myScopeChooserCombo.setCurrentSelection(false);
            }
            this.myRecompileOnChanges.setSelected(TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges());
            this.myTypeScriptNodePackageWrapper.reset();
            this.myUseService.setSelected(TypeScriptConfigurable.this.myServiceSettings.useService());
            this.myExternalSettingsPanel.reset();
            this.updateVisibility();
        }

        private boolean isModified() {
            return TypeScriptConfigurable.this.myDeprecatedSettingsPanel.isModified() || this.myExternalSettingsPanel.isModified() || this.myUseService.isSelected() != TypeScriptConfigurable.this.myServiceSettings.useService() || this.myEnableServiceForProjectsWithoutConfig.isSelected() != TypeScriptConfigurable.this.myServiceSettings.useServiceForProjectsWithoutConfig() || this.myRecompileOnChanges.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges() || this.myTypeScriptNodePackageWrapper.isModified() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myDefaultOptions.getText()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions()) || null != this.myScopeChooserCombo && !StringUtil.equals((CharSequence)this.myScopeChooserCombo.getSelectedScopeName(), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getScopeName()) || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getNodeInterpreterValueForStore()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreter());
        }

        private void setNodeInterpreterField(NodeJsInterpreterField nodeInterpreterTextField) {
            nodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.create(TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreter()));
        }

        @Nullable
        private String getNodeInterpreterValueForStore() {
            NodeJsInterpreterRef interpreterRef = this.myNodeInterpreterTextField.getInterpreterRef();
            return interpreterRef.isProjectRef() ? null : interpreterRef.getReferenceName();
        }
    }
}

