/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceActionPanelBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptIDEGetProjectsInfoRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptIDEGetProjectsInfoResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

public class TypeScriptServiceStructureBuilder
extends SimpleTreeBuilder {
    public static final String STRUCTURE_NAME = "Structure";

    @NotNull
    public static StructurePanel registerStructureContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull String helpId) {
        if (project == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(1);
        }
        if (helpId == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(2);
        }
        Tree tree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        TypeScriptServiceStructure structure = new TypeScriptServiceStructure(ContainerUtil.newHashMap());
        final TypeScriptServiceStructureBuilder builder = new TypeScriptServiceStructureBuilder((JTree)tree, structure);
        final Runnable refresh = () -> {
            if (project == null) {
                TypeScriptServiceStructureBuilder.$$$reportNull$$$0(4);
            }
            List<TypeScriptCompilerService> services = TypeScriptCompilerService.getAll(project);
            for (TypeScriptCompilerService service : services) {
                if (!service.isServiceCreated()) continue;
                service.sendCommand(new TypeScriptIDEGetProjectsInfoRequest(), (obj, answer) -> {
                    JsonObject element = answer.getElement();
                    TypeScriptIDEGetProjectsInfoResponse response = (TypeScriptIDEGetProjectsInfoResponse)JSLanguageServiceQueue.GSON.fromJson((JsonElement)element, TypeScriptIDEGetProjectsInfoResponse.class);
                    if (response.body == null) {
                        structure.setStructures(ContainerUtil.newHashMap());
                        tree.getEmptyText().setText("Project structure isn't available");
                    } else {
                        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
                        for (TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo info : response.body) {
                            result.put(info.projectName, info);
                        }
                        structure.setStructures(result);
                        if (result.isEmpty()) {
                            tree.getEmptyText().setText("Service doesn't contain open projects");
                        }
                    }
                    ApplicationManager.getApplication().invokeLater(() -> builder.queueUpdate());
                    return null;
                });
                break;
            }
            structure.setStructures(ContainerUtil.newHashMap());
            tree.getEmptyText().setText("Refresh required");
            builder.queueUpdate();
        };
        JPanel actionPanel = JSLanguageServiceActionPanelBuilder.createToolPanel(helpId, null, null, new AnAction[]{new AnAction(AllIcons.Actions.ForceRefresh){

            public void actionPerformed(AnActionEvent e) {
                refresh.run();
            }
        }}, null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(ScrollPaneFactory.createScrollPane((Component)tree));
        panel.add("West", actionPanel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        builder.queueUpdate();
        ContentImpl contentImpl = new ContentImpl((JComponent)panel, STRUCTURE_NAME, false);
        toolWindow.getContentManager().addContent((Content)contentImpl);
        contentImpl.setCloseable(false);
        StructurePanel structurePanel = new StructurePanel(){

            @Override
            public void refresh() {
                refresh.run();
            }

            @Override
            public String getName() {
                return TypeScriptServiceStructureBuilder.STRUCTURE_NAME;
            }

            public void dispose() {
                Disposer.dispose((Disposable)builder);
            }
        };
        if (structurePanel == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(3);
        }
        return structurePanel;
    }

    public TypeScriptServiceStructureBuilder(JTree tree, TypeScriptServiceStructure treeStructure) {
        super(tree, new DefaultTreeModel(new DefaultMutableTreeNode()), (AbstractTreeStructure)treeStructure, (Comparator)IndexComparator.INSTANCE);
        this.initRootNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStructureContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStructureContent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerStructureContent$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface StructurePanel
    extends Disposable {
        public void refresh();

        public String getName();
    }
}

