/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.JSDuplicatesProfile;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.JSMatchingStrategy;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    @NotNull
    public CompiledPattern createCompiledPattern() {
        CompiledPattern compiledPattern = new CompiledPattern(){
            {
                this.setStrategy(JSMatchingStrategy.getInstance());
            }

            public String[] getTypedVarPrefixes() {
                return new String[]{JSStructuralSearchProfile.getTypedVarPrefix()};
            }

            public boolean isTypedVar(String str) {
                String prefix = JSStructuralSearchProfile.getTypedVarPrefix();
                return str.startsWith(prefix);
            }
        };
        if (compiledPattern == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return compiledPattern;
    }

    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JSStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(1);
        }
        return nodeFilter;
    }

    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        elements[0].getParent().accept((PsiElementVisitor)new MyJsCompilingVisitor(globalVisitor, elements[0].getParent()));
    }

    private static PsiElement extractOnlyStatement(JSBlockStatement e) {
        if (e.getParent() instanceof JSFunction) {
            return e;
        }
        JSStatement[] statements = e.getStatements();
        if (statements.length == 1) {
            return statements[0];
        }
        return e;
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        MyJsMatchingVisitor myJsMatchingVisitor = new MyJsMatchingVisitor(globalVisitor);
        if (myJsMatchingVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return myJsMatchingVisitor;
    }

    private static boolean isLexicalNode(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        IElementType type = ((LeafElement)element).getElementType();
        return type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON;
    }

    @NotNull
    private static String getTypedVarPrefix() {
        if (TYPED_VAR_PREFIX == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return TYPED_VAR_PREFIX;
    }

    private static boolean isBlockElement(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        return element instanceof JSBlockStatement || element instanceof JSFile;
    }

    private static boolean canBeVariable(PsiElement element) {
        return element instanceof JSExpression || element instanceof JSParameter || element instanceof JSVariable || element instanceof LeafElement && ((LeafElement)element).getElementType() == JSTokenTypes.IDENTIFIER;
    }

    private static boolean canBePatternVariable(PsiElement element) {
        ASTNode node;
        PsiElement child = element.getFirstChild();
        if (child == null) {
            return true;
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSParameter) && (node = child.getNode()) != null) {
            return node.getElementType() == JSTokenTypes.IDENTIFIER && child.getNextSibling() == null;
        }
        return false;
    }

    @NotNull
    private static MatchingStrategy getMatchingStrategy(PsiElement root) {
        if (root != null && JSDuplicatesProfile.getLanguageForElement(root) == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            JSMatchingStrategy jSMatchingStrategy = JSMatchingStrategy.getInstanceEcma();
            if (jSMatchingStrategy == null) {
                JSStructuralSearchProfile.$$$reportNull$$$0(8);
            }
            return jSMatchingStrategy;
        }
        JSMatchingStrategy jSMatchingStrategy = JSMatchingStrategy.getInstance();
        if (jSMatchingStrategy == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return jSMatchingStrategy;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        return language instanceof JavascriptLanguage || language instanceof JSLanguageDialect;
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project, boolean physical) {
        if (text == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        PsiElement[] originalElements = super.createPatternTree(text, context, fileType, language, contextName, extension, project, physical);
        if (context == PatternTreeContext.Block && language == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && JSStructuralSearchProfile.shouldBeParsedInBlockContext(originalElements)) {
            text = "class A { function f() {" + text + "}}";
            PsiElement[] elements = super.createPatternTree(text, context, fileType, language, contextName, extension, project, physical);
            if (elements.length == 0) {
                if (elements == null) {
                    JSStructuralSearchProfile.$$$reportNull$$$0(15);
                }
                return elements;
            }
            for (PsiElement element : elements) {
                if (!(element instanceof JSClass)) continue;
                JSFunction[] functions = ((JSClass)element).getFunctions();
                assert (functions.length == 1);
                JSSourceElement[] body = functions[0].getBody();
                if (body.length == 1 && body[0] instanceof JSBlockStatement) {
                    JSStatement[] jSStatementArray = ((JSBlockStatement)body[0]).getStatements();
                    if (jSStatementArray == null) {
                        JSStructuralSearchProfile.$$$reportNull$$$0(16);
                    }
                    return jSStatementArray;
                }
                if (body == null) {
                    JSStructuralSearchProfile.$$$reportNull$$$0(17);
                }
                return body;
            }
        }
        if (originalElements == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(18);
        }
        return originalElements;
    }

    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaScriptCodeContextType.class;
    }

    private static boolean shouldBeParsedInBlockContext(PsiElement[] elements) {
        final boolean[] result = new boolean[]{true};
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (element instanceof JSFunction || element instanceof JSClass || element instanceof JSAttribute) {
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        PsiElement[] elements;
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        String pattern = matchOptions.getSearchPattern();
        for (PsiElement element : elements = this.createPatternTree(pattern, PatternTreeContext.File, fileType, project, false)) {
            PsiElement lastChild;
            if (!(element instanceof JSExpressionStatement) && !(element instanceof JSVarStatement) || (lastChild = element.getLastChild()) instanceof LeafPsiElement && ((LeafPsiElement)lastChild).getElementType() == JSTokenTypes.SEMICOLON) continue;
            throw new UnsupportedPatternException(SSRBundle.message((String)"replacement.template.expression.not.supported", (Object[])new Object[]{fileType.getName()}));
        }
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(19);
        }
        return new DocumentBasedReplaceHandler(context.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingStrategy";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLexicalNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBlockElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyJsCompilingVisitor
    extends PsiRecursiveElementVisitor {
        private final GlobalCompilingVisitor myGlobalVisitor;
        private final PsiElement myTopElement;

        private MyJsCompilingVisitor(GlobalCompilingVisitor globalVisitor, PsiElement topElement) {
            this.myGlobalVisitor = globalVisitor;
            this.myTopElement = topElement;
        }

        public void visitElement(final PsiElement element) {
            CompiledPattern pattern;
            this.doVisitElement(element);
            if (this.myGlobalVisitor.getContext().getSearchHelper().doOptimizing() && element instanceof LeafElement && ((LeafElement)element).getElementType() == JSTokenTypes.IDENTIFIER && !this.myGlobalVisitor.getContext().getPattern().isTypedVar(element.getText())) {
                OptimizingSearchHelper helper = this.myGlobalVisitor.getContext().getSearchHelper();
                boolean added = helper.addWordToSearchInText(element.getText());
                boolean bl = added = helper.addWordToSearchInCode(element.getText()) || added;
                if (added) {
                    helper.endTransaction();
                }
            }
            if (element instanceof JSExpressionStatement ? this.visitJsReferenceExpression((JSExpressionStatement)element) : element instanceof JSAttributeList && this.visitJsAttributeList((JSAttributeList)element)) {
                return;
            }
            if (element instanceof JSLiteralExpression) {
                this.visitJsLiteralExpression((JSLiteralExpression)element);
            } else if (element instanceof JSStatement) {
                pattern = this.myGlobalVisitor.getContext().getPattern();
                MatchingHandler handler = pattern.getHandler(element);
                if (handler.getFilter() == null) {
                    handler.setFilter(new NodeFilter(){

                        public boolean accepts(PsiElement e) {
                            if (e instanceof JSBlockStatement) {
                                e = JSStructuralSearchProfile.extractOnlyStatement((JSBlockStatement)e);
                            }
                            return DefaultFilter.accepts((PsiElement)(element instanceof JSBlockStatement ? JSStructuralSearchProfile.extractOnlyStatement((JSBlockStatement)element) : element), (PsiElement)e);
                        }
                    });
                }
            } else if (element instanceof JSVariable) {
                pattern = this.myGlobalVisitor.getContext().getPattern();
                MatchingHandler handler = pattern.getHandler(element);
                handler.setFilter(new NodeFilter(){

                    public boolean accepts(PsiElement e) {
                        boolean result = DefaultFilter.accepts((PsiElement)element, (PsiElement)e);
                        if (!result && e instanceof JSLocalVariable) {
                            result = true;
                        }
                        return result;
                    }
                });
            }
        }

        private void initTopLevelElement(PsiElement element, CompiledPattern pattern) {
            MatchingStrategy strategy = null;
            for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
                if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                    if (!(el instanceof PsiWhiteSpace)) continue;
                    this.myGlobalVisitor.addLexicalNode(el);
                    continue;
                }
                el.accept((PsiElementVisitor)this);
                if (this.myGlobalVisitor.getCodeBlockLevel() != 1) continue;
                MatchingStrategy newstrategy = JSStructuralSearchProfile.getMatchingStrategy(el);
                if (strategy == null) {
                    strategy = newstrategy;
                } else if (strategy.getClass() != newstrategy.getClass()) {
                    throw new UnsupportedPatternException(SSRBundle.message((String)"different.strategies.for.top.level.nodes.error.message", (Object[])new Object[0]));
                }
                MatchingHandler matchingHandler = this.myGlobalVisitor.getContext().getPattern().getHandler(el);
                this.myGlobalVisitor.getContext().getPattern().setHandler(el, (MatchingHandler)new TopLevelMatchingHandler(matchingHandler));
            }
            if (this.myGlobalVisitor.getCodeBlockLevel() == 1) {
                if (strategy == null) {
                    strategy = new MatchingStrategy(){

                        public boolean continueMatching(PsiElement start) {
                            return true;
                        }

                        public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
                            return false;
                        }
                    };
                }
                this.myGlobalVisitor.getContext().getPattern().setStrategy(strategy);
            }
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }

        private void doVisitElement(PsiElement element) {
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            if (JSStructuralSearchProfile.isBlockElement(element)) {
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() + 1);
                if (this.myGlobalVisitor.getCodeBlockLevel() == 1) {
                    this.initTopLevelElement(element, pattern);
                } else {
                    super.visitElement(element);
                }
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() - 1);
                return;
            }
            if (JSStructuralSearchProfile.canBePatternVariable(element) && pattern.isRealTypedVar(element)) {
                this.myGlobalVisitor.handle(element);
                MatchingHandler handler = pattern.getHandler(element);
                handler.setFilter(x$0 -> JSStructuralSearchProfile.canBeVariable(x$0));
                return;
            }
            super.visitElement(element);
        }

        private void visitJsLiteralExpression(JSLiteralExpression expression) {
            MatchingHandler handler;
            String value = expression.getText();
            if (value.length() > 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' && (handler = this.myGlobalVisitor.processPatternStringWithFragments(value, GlobalCompilingVisitor.OccurenceKind.LITERAL)) != null) {
                expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        }

        private boolean visitJsReferenceExpression(JSExpressionStatement element) {
            if (!this.isOnlyTopElement((PsiElement)element)) {
                return false;
            }
            JSExpression expression = element.getExpression();
            String expText = expression.getText();
            if (expText == null || !expText.equals(element.getText())) {
                return false;
            }
            MatchingHandler handler = new MatchingHandler(){

                public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                    if (!super.match(patternNode, matchedNode, context)) {
                        return false;
                    }
                    JSExpression jsExpression = ((JSExpressionStatement)patternNode).getExpression();
                    return context.getMatcher().match((PsiElement)jsExpression, matchedNode);
                }
            };
            this.myGlobalVisitor.setHandler((PsiElement)element, handler);
            handler.setFilter(new NodeFilter(){

                public boolean accepts(PsiElement element) {
                    return element instanceof JSExpression || element instanceof LeafElement && ((LeafElement)element).getElementType() == JSTokenTypes.IDENTIFIER;
                }
            });
            return true;
        }

        private boolean visitJsAttributeList(JSAttributeList attrList) {
            if (!this.isOnlyTopElement((PsiElement)attrList)) {
                return false;
            }
            JSAttribute[] attributes = attrList.getAttributes();
            if (attributes.length != 1) {
                return false;
            }
            JSAttribute attribute = attributes[0];
            if (!attribute.getText().equals(attrList.getText())) {
                return false;
            }
            MatchingHandler handler = new MatchingHandler(){

                public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                    if (!super.match(patternNode, matchedNode, context)) {
                        return false;
                    }
                    JSAttribute jsAttr = ((JSAttributeList)patternNode).getAttributes()[0];
                    return context.getMatcher().match((PsiElement)jsAttr, matchedNode);
                }
            };
            this.myGlobalVisitor.setHandler((PsiElement)attrList, handler);
            handler.setFilter(new NodeFilter(){

                public boolean accepts(PsiElement element) {
                    return element instanceof JSAttribute;
                }
            });
            return true;
        }

        private boolean isOnlyTopElement(PsiElement element) {
            PsiElement[] children;
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSFile) && parent != this.myTopElement) {
                return false;
            }
            for (PsiElement child : children = parent instanceof JSBlockStatement ? ((JSBlockStatement)parent).getStatements() : parent.getChildren()) {
                if (child == element || JSStructuralSearchProfile.isLexicalNode(child)) continue;
                return false;
            }
            return true;
        }
    }

    private static class MyJsMatchingVisitor
    extends JSElementVisitor {
        private final GlobalMatchingVisitor myGlobalVisitor;

        private MyJsMatchingVisitor(GlobalMatchingVisitor globalVisitor) {
            this.myGlobalVisitor = globalVisitor;
        }

        public void visitElement(PsiElement element) {
            JSStatement[] statements;
            PsiElement e = this.myGlobalVisitor.getElement();
            if (e instanceof JSBlockStatement && (statements = ((JSBlockStatement)e).getStatements()).length == 1) {
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.match(element, (PsiElement)statements[0]));
                return;
            }
            super.visitElement(element);
            if (JSStructuralSearchProfile.canBePatternVariable(element)) {
                String text = element.getText();
                boolean isTypedVar = this.myGlobalVisitor.getMatchContext().getPattern().isTypedVar(text);
                if (isTypedVar) {
                    this.myGlobalVisitor.setResult(this.myGlobalVisitor.handleTypedElement(element, e));
                } else {
                    this.myGlobalVisitor.setResult(text.equals(e.getText()));
                }
            } else {
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.matchSequentially((NodeIterator)new SsrFilteringNodeIterator(element.getFirstChild()), (NodeIterator)new SsrFilteringNodeIterator(e.getFirstChild())));
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            PsiElement e = this.myGlobalVisitor.getElement();
            if (e instanceof LeafElement && ((LeafElement)e).getElementType() == JSTokenTypes.IDENTIFIER && e.getParent() instanceof JSReferenceExpression) {
                this.myGlobalVisitor.setResult(false);
            } else {
                super.visitJSReferenceExpression(expression);
            }
        }

        public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
        }

        public void visitJSLiteralExpression(JSLiteralExpression l1) {
            JSLiteralExpression l2 = (JSLiteralExpression)this.myGlobalVisitor.getElement();
            MatchingHandler handler = (MatchingHandler)l1.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler instanceof SubstitutionHandler) {
                int offset = 0;
                int length = l2.getTextLength();
                String text = l2.getText();
                if (length > 2 && text.charAt(0) == '\"' && text.charAt(length - 1) == '\"') {
                    --length;
                    ++offset;
                }
                this.myGlobalVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)l2, offset, length, this.myGlobalVisitor.getMatchContext()));
            } else if (handler != null) {
                this.myGlobalVisitor.setResult(handler.match((PsiElement)l1, (PsiElement)l2, this.myGlobalVisitor.getMatchContext()));
            } else {
                this.myGlobalVisitor.setResult(l1.textMatches((PsiElement)l2));
            }
        }

        public void visitJSFunctionDeclaration(JSFunction f1) {
            JSFunction f2 = (JSFunction)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(f1.getKind() == f2.getKind() && this.myGlobalVisitor.match(f1.getNameIdentifier(), f2.getNameIdentifier()) && this.myGlobalVisitor.matchSonsOptionally((PsiElement)f1.getAttributeList(), (PsiElement)f2.getAttributeList()) && this.myGlobalVisitor.matchSons((PsiElement)f1.getParameterList(), (PsiElement)f2.getParameterList()) && this.myGlobalVisitor.matchOptionally(f1.getReturnTypeElement(), f2.getReturnTypeElement()) && this.myGlobalVisitor.matchOptionally((PsiElement[])f1.getBody(), (PsiElement[])f2.getBody()));
        }

        public void visitJSClass(JSClass c1) {
            JSClass c2 = (JSClass)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match(c1.getNameIdentifier(), c2.getNameIdentifier()) && this.myGlobalVisitor.matchSonsOptionally((PsiElement)c1.getAttributeList(), (PsiElement)c2.getAttributeList()) && this.myGlobalVisitor.matchSonsInAnyOrder((PsiElement)c1.getExtendsList(), (PsiElement)c2.getExtendsList()) && this.myGlobalVisitor.matchSonsInAnyOrder((PsiElement)c1.getImplementsList(), (PsiElement)c2.getImplementsList()) && this.myGlobalVisitor.matchInAnyOrder((PsiElement[])c1.getFields(), (PsiElement[])c2.getFields()) && this.myGlobalVisitor.matchInAnyOrder((PsiElement[])c1.getFunctions(), (PsiElement[])c2.getFunctions()));
        }

        public void visitJSVarStatement(JSVarStatement vs1) {
            JSVarStatement vs2 = (JSVarStatement)this.myGlobalVisitor.getElement();
            PsiElement firstChild1 = vs1.getFirstChild();
            PsiElement firstChild2 = vs2.getFirstChild();
            boolean result = true;
            if (firstChild1 instanceof JSAttributeList && firstChild1.getTextLength() > 0) {
                result = firstChild2 instanceof JSAttributeList ? this.myGlobalVisitor.match(firstChild1, firstChild2) : false;
            }
            this.myGlobalVisitor.setResult(result && this.myGlobalVisitor.matchSequentially((PsiElement[])vs1.getVariables(), (PsiElement[])vs2.getVariables()));
        }

        public void visitJSIfStatement(JSIfStatement if1) {
            JSIfStatement if2 = (JSIfStatement)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.myGlobalVisitor.matchOptionally((PsiElement)if1.getThen(), (PsiElement)if2.getThen()) && this.myGlobalVisitor.matchOptionally((PsiElement)if1.getElse(), (PsiElement)if2.getElse()));
        }

        public void visitJSForStatement(JSForStatement for1) {
            JSForStatement for2 = (JSForStatement)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myGlobalVisitor.match((PsiElement)for1.getInitialization(), (PsiElement)for2.getInitialization()) && this.myGlobalVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myGlobalVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.myGlobalVisitor.matchOptionally((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
        }

        public void visitJSForInStatement(JSForInStatement for1) {
            JSForInStatement for2 = (JSForInStatement)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match((PsiElement)for1.getDeclarationStatement(), (PsiElement)for2.getDeclarationStatement()) && this.myGlobalVisitor.match((PsiElement)for1.getVariableExpression(), (PsiElement)for2.getVariableExpression()) && this.myGlobalVisitor.match((PsiElement)for1.getCollectionExpression(), (PsiElement)for1.getCollectionExpression()) && this.myGlobalVisitor.matchOptionally((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement while1) {
            JSDoWhileStatement while2 = (JSDoWhileStatement)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.myGlobalVisitor.matchOptionally((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
        }

        public void visitJSWhileStatement(JSWhileStatement while1) {
            JSWhileStatement while2 = (JSWhileStatement)this.myGlobalVisitor.getElement();
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.myGlobalVisitor.matchOptionally((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
        }

        public void visitJSBlock(JSBlockStatement block1) {
            JSStatement[] jSStatementArray;
            PsiElement element = this.myGlobalVisitor.getElement();
            if (element instanceof JSBlockStatement) {
                jSStatementArray = ((JSBlockStatement)element).getStatements();
            } else {
                PsiElement[] psiElementArray = new PsiElement[1];
                jSStatementArray = psiElementArray;
                psiElementArray[0] = element;
            }
            JSStatement[] statements2 = jSStatementArray;
            this.myGlobalVisitor.setResult(this.myGlobalVisitor.matchSequentially((PsiElement[])block1.getStatements(), (PsiElement[])statements2));
        }
    }
}

