/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MavenConstantListConverter
extends ResolvingConverter<String> {
    private boolean myStrict;

    protected MavenConstantListConverter() {
        this(true);
    }

    protected MavenConstantListConverter(boolean strict) {
        this.myStrict = strict;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (!this.myStrict) {
            return s;
        }
        return this.getValues(context).contains(s) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        Collection<String> collection = this.getValues(context);
        if (collection == null) {
            MavenConstantListConverter.$$$reportNull$$$0(0);
        }
        return collection;
    }

    protected abstract Collection<String> getValues(@NotNull ConvertContext var1);

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return "<html>Specified value is not acceptable here.<br>Acceptable values: " + StringUtil.join(this.getValues(context), (String)", ") + "</html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/MavenConstantListConverter", "getVariants"));
    }
}

