/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringValidator
extends InspectionValidator {
    public SpringValidator() {
        super(SpringApiBundle.message((String)"model.inspection.validator.description.text", (Object[])new Object[0]), SpringBundle.message("model.inspection.validator.progress.text", new Object[0]));
    }

    private static boolean isAvailableOnModule(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module);
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = SpringInspectionsRegistry.getInstance().getSpringInspectionClasses();
        if (classArray == null) {
            SpringValidator.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            SpringValidator.$$$reportNull$$$0(1);
        }
        for (Module module : scope.getAffectedModules()) {
            if (!SpringValidator.isAvailableOnModule(module)) continue;
            return true;
        }
        return false;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            Set models = SpringManager.getInstance((Project)project).getAllModels(module);
            for (SpringModel model : models) {
                for (PsiFile configFile : model.getConfigFiles()) {
                    VirtualFile file = configFile.getVirtualFile();
                    ContainerUtil.addIfNotNull((Collection)files, (Object)file);
                }
            }
        }
        for (Module module : SpringValidator.getAdditionalFilesContributors()) {
            files.addAll(module.getAdditionalFilesToProcess(project, context));
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)files, (CompileContext)context);
        return files;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile topFile) {
        LinkedHashMap additionalHighlighting = ContainerUtil.newLinkedHashMap();
        for (SpringInspectionsRegistry.AdditionalFilesContributor contributor : SpringValidator.getAdditionalFilesContributors()) {
            additionalHighlighting.putAll(contributor.checkAdditionally(topFile));
        }
        LinkedHashMap linkedHashMap = additionalHighlighting;
        if (linkedHashMap == null) {
            SpringValidator.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    @NotNull
    private static SpringInspectionsRegistry.AdditionalFilesContributor[] getAdditionalFilesContributors() {
        SpringInspectionsRegistry.AdditionalFilesContributor[] additionalFilesContributorArray = (SpringInspectionsRegistry.AdditionalFilesContributor[])SpringInspectionsRegistry.AdditionalFilesContributor.EP_NAME.getExtensions();
        if (additionalFilesContributorArray == null) {
            SpringValidator.$$$reportNull$$$0(3);
        }
        return additionalFilesContributorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/SpringValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/SpringValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAdditionally";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFilesContributors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

