/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.settings;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SpringGeneralSettingsUi
implements ConfigurableUi<SpringGeneralSettings> {
    private JPanel myRootPanel;
    private JBCheckBox myShowProfilesPanel;
    private JBCheckBox myShowMultiContextsPanel;
    private JBCheckBox myAllowAutoConfiguration;

    SpringGeneralSettingsUi() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(0);
        }
        this.myShowProfilesPanel.setSelected(settings.isShowProfilesPanel());
        this.myShowMultiContextsPanel.setSelected(settings.isShowMultipleContextsPanel());
        this.myAllowAutoConfiguration.setSelected(settings.isAllowAutoConfigurationMode());
    }

    public boolean isModified(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(1);
        }
        return this.hasModifiedEditorPanelSettings(settings);
    }

    private boolean hasModifiedEditorPanelSettings(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(2);
        }
        return settings.isShowProfilesPanel() != this.myShowProfilesPanel.isSelected() || settings.isShowMultipleContextsPanel() != this.myShowMultiContextsPanel.isSelected() || settings.isAllowAutoConfigurationMode() != this.myAllowAutoConfiguration.isSelected();
    }

    public void apply(@NotNull SpringGeneralSettings settings) throws ConfigurationException {
        if (settings == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(3);
        }
        if (this.hasModifiedEditorPanelSettings(settings)) {
            settings.setShowProfilesPanel(this.myShowProfilesPanel.isSelected());
            settings.setShowMultipleContextsPanel(this.myShowMultiContextsPanel.isSelected());
            settings.setAllowAutoConfigurationMode(this.myAllowAutoConfiguration.isSelected());
            EditorNotifications.updateAll();
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            SpringGeneralSettingsUi.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/settings/SpringGeneralSettingsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/settings/SpringGeneralSettingsUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifiedEditorPanelSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Configuration Files Editor", (int)1, (int)0, null, null));
        this.myShowProfilesPanel = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Show Profiles panel");
        jBCheckBox3.setMnemonic('P');
        jBCheckBox3.setDisplayedMnemonicIndex(5);
        jBCheckBox3.setToolTipText("Allow choosing active profile(s)");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowMultiContextsPanel = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show Multiple Contexts panel");
        jBCheckBox2.setMnemonic('M');
        jBCheckBox2.setDisplayedMnemonicIndex(5);
        jBCheckBox2.setToolTipText("Allow choosing active context if file is used in multiple contexts");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Common", (int)1, (int)0, null, null));
        this.myAllowAutoConfiguration = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Allow to auto-configure application contexts");
        jBCheckBox.setToolTipText("");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

