/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringInfrastructureBean;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerDependenciesListener;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPointerFinderRecursivePanel
extends FinderRecursivePanel<SpringBeanPointer> {
    public static final ExtensionPointName<SpringBeanPointerPanelContent> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.beanPointerPanelContent");
    private final NullableFactory<CommonSpringModel> myModelFactory;
    private Set<PsiFile> modelFiles;

    public SpringBeanPointerFinderRecursivePanel(@NotNull Project project, @Nullable String groupId, @NotNull NullableFactory<CommonSpringModel> modelFactory) {
        if (project == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (modelFactory == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        super(project, groupId);
        this.modelFiles = Collections.emptySet();
        this.myModelFactory = modelFactory;
        this.installDependenciesListener();
    }

    public SpringBeanPointerFinderRecursivePanel(@NotNull FinderRecursivePanel panel, @NotNull NullableFactory<CommonSpringModel> modelFactory) {
        if (panel == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        if (modelFactory == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        super(panel);
        this.modelFiles = Collections.emptySet();
        this.myModelFactory = modelFactory;
        this.installDependenciesListener();
    }

    private boolean isNotDumb() {
        return !DumbService.isDumb((Project)this.getProject());
    }

    private void installDependenciesListener() {
        new SpringBeanPointerDependenciesListener(this);
    }

    boolean knowsAboutConfigurationFile(PsiFile file) {
        return this.modelFiles.contains(file);
    }

    @NotNull
    protected List<SpringBeanPointer> getListItems() {
        CommonSpringModel commonSpringModel = (CommonSpringModel)this.myModelFactory.create();
        if (commonSpringModel == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(4);
            }
            return list;
        }
        this.modelFiles = new HashSet<PsiFile>(commonSpringModel.getConfigFiles());
        List<SpringBeanPointer> localBeans = this.getSortedAndFilteredItems(commonSpringModel.getAllCommonBeans());
        for (SpringBeanPointer bean : localBeans) {
            this.modelFiles.add(bean.getContainingFile());
        }
        List<SpringBeanPointer> list = localBeans;
        if (list == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<SpringBeanPointer> getSortedAndFilteredItems(Collection<SpringBeanPointer> beans) {
        TreeSet<SpringBeanPointer> pointers = new TreeSet<SpringBeanPointer>(Comparator.comparing(this::getItemText, NaturalComparator.INSTANCE));
        boolean showImplicitBeans = this.getSettings().isShowImplicitBeans();
        boolean showInfrastructureBeans = this.getSettings().isShowInfrastructureBeans();
        pointers.addAll(ContainerUtil.filter(beans, springBeanPointer -> {
            if (!showImplicitBeans && springBeanPointer.getSpringBean() instanceof SpringImplicitBeanMarker) {
                return false;
            }
            return showInfrastructureBeans || !(springBeanPointer.getSpringBean() instanceof SpringInfrastructureBean);
        }));
        return new ArrayList<SpringBeanPointer>(pointers);
    }

    @NotNull
    protected String getItemText(SpringBeanPointer pointer) {
        String string = this.isNotDumb() && pointer.isValid() ? SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer) : "<invalid>";
        if (string == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringBeanPointer pointer) {
        return this.isNotDumb() && pointer.isValid() ? SpringPresentationProvider.getSpringIcon((Object)pointer) : null;
    }

    protected boolean hasChildren(SpringBeanPointer springBeanPointer) {
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(SpringBeanPointer pointer) {
        return pointer.isValid() ? pointer.getContainingFile().getVirtualFile() : null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        Object data;
        SpringBeanPointer selectedValue = (SpringBeanPointer)this.getSelectedValue();
        if (selectedValue != null && selectedValue.isValid()) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return selectedValue.getSpringBean().getIdentifyingPsiElement();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return selectedValue.getContainingFile();
            }
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        for (SpringBeanPointerPanelContent content : (SpringBeanPointerPanelContent[])EP_NAME.getExtensions()) {
            Object contentData = content.getData(this, dataId);
            if (contentData == null) continue;
            return contentData;
        }
        return null;
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    protected JComponent createDefaultRightComponent() {
        SpringBeansViewSettings settings = this.getSettings();
        if (!(settings.isShowDoc() || settings.isShowGraph() && ((SpringBeanPointerPanelContent[])EP_NAME.getExtensions()).length != 0)) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(SpringBeanPointer pointer) {
        SpringBeansViewSettings settings = this.getSettings();
        SpringBeanPointerPanelContent[] contentExtensions = (SpringBeanPointerPanelContent[])EP_NAME.getExtensions();
        if (!(settings.isShowDoc() || settings.isShowGraph() && contentExtensions.length != 0)) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel disposablePanel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        BorderLayoutPanel panel = JBUI.Panels.simplePanel((int)0, (int)2);
        disposablePanel.add((Component)panel, (Object)"Center");
        if (!pointer.isValid() || this.isDisposed()) {
            return disposablePanel;
        }
        if (settings.isShowDoc()) {
            PsiElement element = pointer.getSpringBean().getIdentifyingPsiElement();
            DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
            DocumentationComponent documentationComponent = new DocumentationComponent(manager);
            Disposer.register((Disposable)disposablePanel, (Disposable)documentationComponent);
            manager.fetchDocInfo(element, documentationComponent);
            panel.add((Component)documentationComponent, (Object)"North");
        }
        if (settings.isShowGraph()) {
            for (SpringBeanPointerPanelContent content : contentExtensions) {
                JComponent component = content.createComponent(this, (Disposable)disposablePanel, this.myModelFactory, pointer);
                panel.add((Component)component, (Object)"Center");
            }
        }
        return disposablePanel;
    }

    @Nullable
    protected String getItemTooltipText(SpringBeanPointer pointer) {
        PsiType beanType;
        CommonSpringBean bean;
        CommonSpringBean commonSpringBean = bean = pointer.isValid() ? pointer.getSpringBean() : null;
        if (bean != null && (beanType = bean.getBeanType(true)) != null) {
            return beanType.getCanonicalText();
        }
        return null;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        if (!this.getSettings().isShowGraph()) {
            return;
        }
        for (SpringBeanPointerPanelContent content : (SpringBeanPointerPanelContent[])EP_NAME.getExtensions()) {
            content.update(this);
        }
    }

    private SpringBeansViewSettings getSettings() {
        return SpringBeansViewSettings.getInstance(this.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/panels/SpringBeanPointerFinderRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/panels/SpringBeanPointerFinderRecursivePanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SpringBeanPointerPanelContent {
        public JComponent createComponent(FinderRecursivePanel var1, Disposable var2, NullableFactory<CommonSpringModel> var3, SpringBeanPointer var4);

        public void update(FinderRecursivePanel var1);

        public Object getData(FinderRecursivePanel var1, @NonNls String var2);
    }
}

