/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.constants.EnumValue;

public class WhenByEnumsMapping {
    public static final String MAPPING_ARRAY_FIELD_PREFIX = "$EnumSwitchMapping$";
    public static final String MAPPINGS_CLASS_NAME_POSTFIX = "$WhenMappings";
    private final Map<EnumValue, Integer> map = new LinkedHashMap<EnumValue, Integer>();
    private final ClassDescriptor enumClassDescriptor;
    private final String outerClassInternalNameForExpression;
    private final String mappingsClassInternalName;
    private final int fieldNumber;

    public WhenByEnumsMapping(@NotNull ClassDescriptor enumClassDescriptor, @NotNull String outerClassInternalNameForExpression, int fieldNumber) {
        this.enumClassDescriptor = enumClassDescriptor;
        this.outerClassInternalNameForExpression = outerClassInternalNameForExpression;
        this.mappingsClassInternalName = outerClassInternalNameForExpression + MAPPINGS_CLASS_NAME_POSTFIX;
        this.fieldNumber = fieldNumber;
    }

    public int getIndexByEntry(@NotNull EnumValue value2) {
        Integer result2 = this.map.get(value2);
        assert (result2 != null) : "entry " + value2 + " has no mapping";
        return result2;
    }

    public void putFirstTime(@NotNull EnumValue value2, int index2) {
        if (!this.map.containsKey(value2)) {
            this.map.put(value2, index2);
        }
    }

    public int size() {
        return this.map.size();
    }

    @NotNull
    public String getFieldName() {
        return MAPPING_ARRAY_FIELD_PREFIX + this.fieldNumber;
    }

    @NotNull
    public ClassDescriptor getEnumClassDescriptor() {
        return this.enumClassDescriptor;
    }

    @NotNull
    public String getOuterClassInternalNameForExpression() {
        return this.outerClassInternalNameForExpression;
    }

    @NotNull
    public String getMappingsClassInternalName() {
        return this.mappingsClassInternalName;
    }

    @NotNull
    public Iterable<Map.Entry<EnumValue, Integer>> enumValuesToIntMapping() {
        return this.map.entrySet();
    }
}

