/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSimpleGetterProvider;", "Lcom/intellij/debugger/engine/SimplePropertyGetterProvider;", "()V", "isInsideSimpleGetter", "", "element", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinSimpleGetterProvider
implements SimplePropertyGetterProvider {
    public boolean isInsideSimpleGetter(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtParameter) {
            return true;
        }
        KtPropertyAccessor accessor = (KtPropertyAccessor)PsiTreeUtil.getParentOfType((PsiElement)element3, KtPropertyAccessor.class);
        if (accessor != null && accessor.isGetter()) {
            boolean bl;
            KtExpression body2 = accessor.getBodyExpression();
            KtExpression ktExpression = body2;
            if (ktExpression instanceof KtBlockExpression) {
                KtExpression ktExpression2;
                List<KtExpression> list2 = ((KtBlockExpression)body2).getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
                Object object = CollectionsKt.singleOrNull(list2);
                if (!(object instanceof KtReturnExpression)) {
                    object = null;
                }
                if ((ktExpression2 = (KtReturnExpression)object) == null || (ktExpression2 = ktExpression2.getReturnedExpression()) == null) {
                    return false;
                }
                KtExpression returnedExpression = ktExpression2;
                bl = returnedExpression.textMatches("field");
            } else {
                bl = ktExpression instanceof KtExpression ? body2.textMatches("field") : false;
            }
            return bl;
        }
        KtProperty property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)element3, KtProperty.class);
        if (property2 != null) {
            return property2.getGetter() == null && !property2.isLocal();
        }
        return false;
    }
}

