/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.ui.LayeredIcon;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int usageCount;
    private final Set<PsiReference> references;
    private final CallHierarchyNodeDescriptor javaDelegate;

    public KotlinCallHierarchyNodeDescriptor(@Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull KtElement element3, boolean isBase, boolean navigateToReference) {
        if (element3 == null) {
            KotlinCallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(element3.getProject(), (NodeDescriptor)parentDescriptor, (PsiElement)element3, isBase);
        this.usageCount = 1;
        this.references = new HashSet<PsiReference>();
        this.javaDelegate = new CallHierarchyNodeDescriptor(this.myProject, null, (PsiElement)element3, isBase, navigateToReference);
    }

    public final void incrementUsageCount() {
        ++this.usageCount;
        this.javaDelegate.incrementUsageCount();
    }

    public final void addReference(PsiReference reference2) {
        this.references.add(reference2);
        this.javaDelegate.addReference(reference2);
    }

    public final boolean isValid() {
        PsiElement myElement = this.getPsiElement();
        return myElement != null && myElement.isValid();
    }

    public final boolean update() {
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement targetElement = this.getPsiElement();
        String elementText = KotlinCallHierarchyNodeDescriptor.renderElement(targetElement);
        if (elementText == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newIcon = targetElement.getIcon(flags);
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(newIcon, 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            newIcon = icon;
        }
        this.setIcon(newIcon);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        String packageName = KtPsiUtil.getPackageName((KtElement)targetElement);
        this.myHighlightedText.getEnding().addText(elementText, mainTextAttributes);
        if (this.usageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.usageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        if (packageName == null) {
            packageName = "";
        }
        this.myHighlightedText.getEnding().addText("  (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    @Nullable
    private static String renderElement(@Nullable PsiElement element3) {
        String elementText;
        String containerText = null;
        if (element3 instanceof KtFile) {
            elementText = ((KtFile)element3).getName();
        } else if (element3 instanceof KtNamedDeclaration) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.FULL);
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
            if (descriptor2 == null) {
                return null;
            }
            if (element3 instanceof KtClassOrObject) {
                if (element3 instanceof KtObjectDeclaration && ((KtObjectDeclaration)element3).isCompanion()) {
                    if (!((descriptor2 = descriptor2.getContainingDeclaration()) instanceof ClassDescriptor)) {
                        return null;
                    }
                    elementText = KotlinCallHierarchyNodeDescriptor.renderClassOrObject((ClassDescriptor)descriptor2);
                } else {
                    elementText = element3 instanceof KtEnumEntry ? ((KtEnumEntry)element3).getName() : (((KtClassOrObject)element3).getName() != null ? KotlinCallHierarchyNodeDescriptor.renderClassOrObject((ClassDescriptor)descriptor2) : "[anonymous]");
                }
            } else if (element3 instanceof KtNamedFunction || element3 instanceof KtConstructor) {
                elementText = KotlinCallHierarchyNodeDescriptor.renderNamedFunction((FunctionDescriptor)descriptor2);
            } else if (element3 instanceof KtProperty) {
                elementText = ((KtProperty)element3).getName();
            } else {
                return null;
            }
            for (DeclarationDescriptor containerDescriptor = descriptor2.getContainingDeclaration(); containerDescriptor != null; containerDescriptor = containerDescriptor.getContainingDeclaration()) {
                String name2 = containerDescriptor.getName().asString();
                if (name2.startsWith("<")) continue;
                containerText = name2;
                break;
            }
        } else {
            return null;
        }
        if (elementText == null) {
            return null;
        }
        return containerText != null ? containerText + "." + elementText : elementText;
    }

    public static String renderNamedFunction(FunctionDescriptor descriptor2) {
        DeclarationDescriptor descriptorForName = descriptor2 instanceof ConstructorDescriptor ? descriptor2.getContainingDeclaration() : descriptor2;
        String name2 = descriptorForName.getName().asString();
        String paramTypes = StringUtil.join(descriptor2.getValueParameters(), descriptor1 -> DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(descriptor1.getType()), (String)", ");
        return name2 + "(" + paramTypes + ")";
    }

    private static String renderClassOrObject(ClassDescriptor descriptor2) {
        return descriptor2.getName().asString();
    }

    public void navigate(boolean requestFocus) {
        this.javaDelegate.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.javaDelegate.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.javaDelegate.canNavigateToSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor", "<init>"));
    }
}

