/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.ConvertToScopeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\n*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToApplyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "createScopeExpression", "Lorg/jetbrains/kotlin/psi/KtProperty;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "findCallExpressionFrom", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "scopeExpression", "isApplicableTo", "", "caretOffset", "", "findTargetProperty", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "receiverExpressionText", "", "isApplicable", "idea"})
public final class ConvertToApplyIntention
extends ConvertToScopeIntention<KtExpression> {
    @Override
    @Nullable
    protected KtCallExpression findCallExpressionFrom(@NotNull KtExpression scopeExpression) {
        Intrinsics.checkParameterIsNotNull((Object)scopeExpression, (String)"scopeExpression");
        KtExpression ktExpression = scopeExpression;
        if (!(ktExpression instanceof KtProperty)) {
            ktExpression = null;
        }
        KtProperty ktProperty = (KtProperty)ktExpression;
        KtExpression ktExpression2 = ktProperty != null ? ktProperty.getInitializer() : null;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        return ktQualifiedExpression != null ? UtilsKt.getCallExpression(ktQualifiedExpression) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (!(ktExpression instanceof KtProperty)) {
            if (!(ktExpression instanceof KtDotQualifiedExpression)) return false;
            String receiverExpressionText = UtilsKt.getLeftMostReceiverExpression((KtDotQualifiedExpression)element3).getText();
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)element3;
            String string = receiverExpressionText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"receiverExpressionText");
            if (!this.isApplicableWithGivenReceiverText(ktDotQualifiedExpression, string)) return false;
            KtProperty ktProperty = this.findTargetProperty((KtDotQualifiedExpression)element3, receiverExpressionText);
            if (ktProperty == null) return false;
            boolean bl = this.isApplicable(ktProperty);
            if (!bl) return false;
            return true;
        }
        boolean bl = this.isApplicable((KtProperty)element3);
        return bl;
    }

    private final boolean isApplicable(@NotNull KtProperty $receiver) {
        if (!$receiver.isLocal()) {
            return false;
        }
        String string = $receiver.getName();
        if (string == null) {
            return false;
        }
        String localVariableName = string;
        KtDotQualifiedExpression firstDotQualified = this.getDotQualifiedSiblingIfAny($receiver, true);
        if (firstDotQualified != null) {
            String string2 = localVariableName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localVariableName");
            if (this.isApplicableWithGivenReceiverText(firstDotQualified, string2)) {
                KtDotQualifiedExpression nextDotQualified = this.getDotQualifiedSiblingIfAny(firstDotQualified, true);
                return nextDotQualified != null && this.isApplicableWithGivenReceiverText(nextDotQualified, localVariableName);
            }
        }
        return false;
    }

    private final KtProperty findTargetProperty(@NotNull KtDotQualifiedExpression $receiver, String receiverExpressionText) {
        PsiElement target = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)$receiver, false);
        PsiElement psiElement2 = target;
        if (psiElement2 instanceof KtProperty) {
            if (Intrinsics.areEqual((Object)((KtProperty)target).getName(), (Object)receiverExpressionText)) {
                return (KtProperty)target;
            }
        } else if (psiElement2 instanceof KtDotQualifiedExpression && this.isApplicableWithGivenReceiverText((KtDotQualifiedExpression)target, receiverExpressionText)) {
            return this.findTargetProperty((KtDotQualifiedExpression)target, receiverExpressionText);
        }
        return null;
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtProperty) {
            String string = ((KtProperty)element3).getName();
            if (string == null) {
                return;
            }
            this.applyWithGivenReceiverText(element3, string);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            String string = this.getReceiverExpressionText((KtDotQualifiedExpression)element3);
            if (string == null) {
                return;
            }
            String receiverExpressionText = string;
            KtProperty ktProperty = this.findTargetProperty((KtDotQualifiedExpression)element3, receiverExpressionText);
            if (ktProperty == null) {
                return;
            }
            KtProperty property2 = ktProperty;
            this.applyWithGivenReceiverText((KtExpression)property2, receiverExpressionText);
        }
    }

    @Nullable
    protected KtProperty createScopeExpression(@NotNull KtPsiFactory factory2, @NotNull KtExpression element3) {
        String receiverExpressionText;
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtProperty)) {
            return null;
        }
        String string = ((KtProperty)element3).getName();
        if (string == null) {
            return null;
        }
        String string2 = receiverExpressionText = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"receiverExpressionText");
        KtTypeReference ktTypeReference = ((KtProperty)element3).getTypeReference();
        KtExpression ktExpression = ((KtProperty)element3).getInitializer();
        return factory2.createProperty(string2, ktTypeReference != null ? ktTypeReference.getText() : null, ((KtProperty)element3).isVar(), "" + (ktExpression != null ? ktExpression.getText() : null) + ".apply{}");
    }

    public ConvertToApplyIntention() {
        super(KtExpression.class, "Convert to apply");
    }
}

