/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.run.MultiplatformGradleProjectTaskRunnerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/run/MultiplatformGradleOrderEnumeratorHandler;", "Lcom/intellij/openapi/roots/OrderEnumerationHandler;", "()V", "addCustomModuleRoots", "", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "result", "", "", "includeProduction", "includeTests", "addOutputModuleRoots", "", "directorySet", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceDirectorySet;", "FactoryImpl", "idea-gradle"})
public final class MultiplatformGradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    /*
     * WARNING - void declaration
     */
    public boolean addCustomModuleRoots(@NotNull OrderRootType type2, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests) {
        VirtualFile[] implModule;
        Object[] externalProjectDataCache;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (Intrinsics.areEqual((Object)type2, (Object)OrderRootType.CLASSES) ^ true) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        GradleSystemRunningSettings gradleSystemRunningSettings = GradleSystemRunningSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleSystemRunningSettings, (String)"GradleSystemRunningSettings.getInstance()");
        if (!gradleSystemRunningSettings.isUseGradleAwareMake()) {
            Module module = rootModel.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"rootModel.module");
            String string = ExternalSystemModulePropertyManager.Companion.getInstance(module).getRootProjectPath();
            if (string == null) {
                return false;
            }
            String gradleProjectPath = string;
            Module module2 = rootModel.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"rootModel.module");
            Object[] objectArray = ExternalProjectDataCache.getInstance((Project)module2.getProject());
            if (objectArray == null) {
                Intrinsics.throwNpe();
            }
            externalProjectDataCache = objectArray;
            ExternalProject externalProject = externalProjectDataCache.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
            if (externalProject == null) {
                return false;
            }
            ExternalProject externalRootProject = externalProject;
            Map externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
            for (VirtualFile sourceSet : externalSourceSets.values()) {
                if (includeTests) {
                    VirtualFile virtualFile2 = sourceSet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"sourceSet");
                    this.addOutputModuleRoots((ExternalSourceDirectorySet)virtualFile2.getSources().get(ExternalSystemSourceType.TEST), result2);
                }
                if (!includeProduction) continue;
                VirtualFile virtualFile3 = sourceSet;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"sourceSet");
                this.addOutputModuleRoots((ExternalSourceDirectorySet)virtualFile3.getSources().get(ExternalSystemSourceType.SOURCE), result2);
            }
        }
        Module module = rootModel.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"rootModel.module");
        VirtualFile[] virtualFileArray = implModule = KotlinRunConfigurationProducerKt.findJvmImplementationModule(module);
        if (implModule != null && (virtualFileArray = ProjectRootsUtilKt.getRootManager((Module)virtualFileArray)) != null && (virtualFileArray = virtualFileArray.orderEntries()) != null && (virtualFileArray = virtualFileArray.satisfying((Condition)new Condition<OrderEntry>(rootModel){
            final /* synthetic */ ModuleRootModel $rootModel;

            public final boolean value(OrderEntry orderEntry) {
                OrderEntry orderEntry2 = orderEntry;
                if (!(orderEntry2 instanceof ModuleOrderEntry)) {
                    orderEntry2 = null;
                }
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry2;
                return Intrinsics.areEqual((Object)(moduleOrderEntry != null ? moduleOrderEntry.getModule() : null), (Object)this.$rootModel.getModule()) ^ true;
            }
            {
                this.$rootModel = moduleRootModel;
            }
        })) != null && (virtualFileArray = virtualFileArray.compileOnly()) != null && (virtualFileArray = virtualFileArray.getClassesRoots()) != null) {
            void $receiver$iv;
            externalProjectDataCache = virtualFileArray;
            for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                String string;
                void it;
                VirtualFile sourceSet;
                void item$iv = $receiver$iv[i];
                sourceSet = (VirtualFile)item$iv;
                Collection<String> collection = result2;
                void v10 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)v10.getUrl(), (String)"it.url");
                collection.add(string);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addOutputModuleRoots(ExternalSourceDirectorySet directorySet, Collection<String> result2) {
        Object object = directorySet;
        if (object != null && (object = object.getGradleOutputDirs()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object item$iv : $receiver$iv) {
                String string;
                void it;
                File file2 = (File)item$iv;
                Collection<String> collection = result2;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)VfsUtilCore.pathToUrl((String)v1.getAbsolutePath()), (String)"VfsUtilCore.pathToUrl(it.absolutePath)");
                collection.add(string);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/run/MultiplatformGradleOrderEnumeratorHandler$FactoryImpl;", "Lcom/intellij/openapi/roots/OrderEnumerationHandler$Factory;", "()V", "createHandler", "Lcom/intellij/openapi/roots/OrderEnumerationHandler;", "module", "Lcom/intellij/openapi/module/Module;", "isApplicable", "", "idea-gradle"})
    public static final class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) && MultiplatformGradleProjectTaskRunnerKt.access$isMultiplatformModule(module);
        }

        @NotNull
        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return new MultiplatformGradleOrderEnumeratorHandler();
        }
    }
}

